/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import universum.studios.android.widget.adapter.BaseListAdapter;
import universum.studios.android.widget.adapter.DataSetItemPositionResolver;
import universum.studios.android.widget.adapter.OnDataSetSwapListener;
import universum.studios.android.widget.adapter.SimpleAdapter;
import universum.studios.android.widget.adapter.SimpleAdapterDataSet;
import universum.studios.android.widget.adapter.SwappableDataSetAdapterListeners;
import universum.studios.android.widget.adapter.holder.ViewHolder;
import universum.studios.android.widget.adapter.holder.ViewHolderBinders;
import universum.studios.android.widget.adapter.holder.ViewHolderFactories;

public class SimpleListAdapter<A extends SimpleListAdapter, VH extends ViewHolder, I>
extends BaseListAdapter<A, VH, I>
implements SimpleAdapter<I> {
    private final SimpleAdapterDataSet<I> dataSet;
    private SwappableDataSetAdapterListeners<List<I>> listeners;

    public SimpleListAdapter(@NonNull Context context) {
        this(context, new SimpleAdapterDataSet());
    }

    public SimpleListAdapter(@NonNull Context context, @NonNull I[] items) {
        this(context, Arrays.asList(items));
    }

    public SimpleListAdapter(@NonNull Context context, @NonNull List<I> items) {
        this(context, new SimpleAdapterDataSet<I>(items));
    }

    @VisibleForTesting
    SimpleListAdapter(Context context, SimpleAdapterDataSet<I> dataSet) {
        super(context);
        this.dataSet = dataSet;
        this.dataSet.setItemsCallback(new SimpleAdapterDataSet.SimpleItemsCallback(){

            @Override
            void onItemsChanged() {
                SimpleListAdapter.this.notifyDataSetChanged();
            }
        });
        this.dataSet.setItemPositionResolver(new DataSetItemPositionResolver(this));
        this.setHolderFactory(ViewHolderFactories.simple());
        this.setHolderBinder(ViewHolderBinders.simple());
    }

    @Override
    public void registerOnDataSetSwapListener(@NonNull OnDataSetSwapListener<List<I>> listener) {
        if (this.listeners == null) {
            this.listeners = new SwappableDataSetAdapterListeners();
        }
        this.listeners.registerOnDataSetSwapListener(listener);
    }

    @Override
    public void unregisterOnDataSetSwapListener(@NonNull OnDataSetSwapListener<List<I>> listener) {
        if (this.listeners != null) {
            this.listeners.unregisterOnDataSetSwapListener(listener);
        }
    }

    @Override
    public void changeItems(@Nullable List<I> items) {
        this.swapItems(items);
    }

    @Override
    @Nullable
    public List<I> swapItems(@Nullable List<I> items) {
        this.notifyItemsSwapStarted(items);
        List<I> oldItems = this.onSwapItems(items);
        this.notifyItemsSwapFinished(items);
        this.notifyDataSetChanged();
        return oldItems;
    }

    protected final void notifyItemsSwapStarted(@Nullable List<I> items) {
        if (this.listeners != null) {
            this.listeners.notifyDataSetSwapStarted(items);
        }
    }

    @Nullable
    protected List<I> onSwapItems(@Nullable List<I> items) {
        return this.dataSet.swapItems(items);
    }

    protected final void notifyItemsSwapFinished(@Nullable List<I> items) {
        if (this.listeners != null) {
            this.listeners.notifyDataSetSwapFinished(items);
        }
    }

    @Override
    public void insertItem(@NonNull I item) {
        this.dataSet.insertItem(item);
    }

    @Override
    public void insertItem(int position, @NonNull I item) {
        this.dataSet.insertItem(position, item);
    }

    @Override
    public void insertItems(@NonNull List<I> items) {
        this.dataSet.insertItems(items);
    }

    @Override
    public void insertItems(int positionStart, @NonNull List<I> items) {
        this.dataSet.insertItems(positionStart, items);
    }

    @Override
    @NonNull
    public I swapItem(int position, @NonNull I item) {
        return this.dataSet.swapItem(position, item);
    }

    @Override
    @NonNull
    public I swapItemById(long itemId, @NonNull I item) {
        return this.dataSet.swapItemById(itemId, item);
    }

    @Override
    public void moveItem(int fromPosition, int toPosition) {
        this.dataSet.moveItem(fromPosition, toPosition);
    }

    @Override
    @NonNull
    public I removeItem(int position) {
        return this.dataSet.removeItem(position);
    }

    @Override
    public int removeItem(@NonNull I item) {
        return this.dataSet.removeItem(item);
    }

    @Override
    @NonNull
    public I removeItemById(long itemId) {
        return this.dataSet.removeItemById(itemId);
    }

    @Override
    @NonNull
    public List<I> removeItems(int positionStart, int itemCount) {
        return this.dataSet.removeItems(positionStart, itemCount);
    }

    @Override
    @Nullable
    public List<I> getItems() {
        return this.dataSet.getItems();
    }

    @Override
    public int getItemCount() {
        return this.dataSet.getItemCount();
    }

    @Override
    public boolean hasItemAt(int position) {
        return this.dataSet.hasItemAt(position);
    }

    @Override
    @NonNull
    public I getItem(int position) {
        return this.dataSet.getItem(position);
    }
}

