/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter.module;

import android.os.Parcelable;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import universum.studios.android.widget.adapter.AdapterSavedState;

public abstract class AdapterModule {
    ModuleAdapter adapter;
    private boolean notificationEnabled = true;

    public final void attachToAdapter(@NonNull ModuleAdapter adapter) {
        this.adapter = adapter;
        this.onAttachedToAdapter(this.adapter);
    }

    protected void onAttachedToAdapter(@NonNull ModuleAdapter adapter) {
    }

    protected final void assertAttachedToAdapterOrThrow() {
        if (this.adapter == null) {
            throw new IllegalStateException("Not attached to adapter.");
        }
    }

    public void setAdapterNotificationEnabled(boolean enabled) {
        this.notificationEnabled = enabled;
    }

    public boolean isAdapterNotificationEnabled() {
        return this.notificationEnabled;
    }

    protected final void notifyAdapter() {
        if (this.isAdapterNotificationEnabled() && this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public boolean requiresStateSaving() {
        return false;
    }

    @CallSuper
    @NonNull
    public Parcelable saveInstanceState() {
        return AdapterSavedState.EMPTY_STATE;
    }

    @CallSuper
    public void restoreInstanceState(@NonNull Parcelable savedState) {
    }

    public static interface ModuleAdapter {
        public void notifyDataSetChanged();

        public int getItemCount();

        public long getItemId(int var1);
    }
}

