/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter.holder;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.List;

public interface AdapterHolder {
    public static final int NO_POSITION = -1;
    public static final int BASIC_TYPE = 0;

    public int getItemViewType();

    public int getAdapterPosition();

    public static interface BinderAdapter<A, H extends AdapterHolder>
    extends ItemAdapter {
        public void setHolderBinder(@Nullable Binder<A, H> var1);

        @Nullable
        public Binder<A, H> getHolderBinder();
    }

    public static interface Binder<A, H extends AdapterHolder> {
        public void bindHolder(@NonNull A var1, @NonNull H var2, int var3, @NonNull List<Object> var4);
    }

    public static interface FactoryAdapter<H extends AdapterHolder> {
        public void setHolderFactory(@Nullable Factory<H> var1);

        @Nullable
        public Factory<H> getHolderFactory();
    }

    public static abstract class InflaterFactory<H extends AdapterHolder>
    implements Factory<H> {
        private LayoutInflater inflater;

        public InflaterFactory() {
        }

        public InflaterFactory(@NonNull Context context) {
            this(LayoutInflater.from((Context)context));
        }

        public InflaterFactory(@NonNull LayoutInflater inflater) {
            this.inflater = inflater;
        }

        @NonNull
        public View inflateView(@LayoutRes int resource, @NonNull ViewGroup parent) {
            if (this.inflater == null) {
                this.inflater = LayoutInflater.from((Context)parent.getContext());
            }
            return this.inflater.inflate(resource, parent, false);
        }
    }

    public static interface Factory<H extends AdapterHolder> {
        @NonNull
        public H createHolder(@NonNull ViewGroup var1, int var2);
    }

    public static interface ItemAdapter {
        @NonNull
        public Object getItem(int var1);
    }
}

