/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Collections;
import universum.studios.android.widget.adapter.AdapterExceptions;
import universum.studios.android.widget.adapter.AdapterSavedState;
import universum.studios.android.widget.adapter.DataSetAdapter;
import universum.studios.android.widget.adapter.DataSetListeners;
import universum.studios.android.widget.adapter.OnDataSetActionListener;
import universum.studios.android.widget.adapter.OnDataSetListener;
import universum.studios.android.widget.adapter.holder.AdapterHolder;
import universum.studios.android.widget.adapter.holder.ViewHolder;

public abstract class BaseListAdapter<A extends BaseListAdapter, VH extends ViewHolder, I>
extends BaseAdapter
implements DataSetAdapter<I>,
AdapterHolder.FactoryAdapter<VH>,
AdapterHolder.BinderAdapter<A, VH> {
    @NonNull
    private final Context context;
    @NonNull
    private final Resources resources;
    private final LayoutInflater layoutInflater;
    private DataSetListeners dataSetListeners;
    private AdapterHolder.Factory<VH> holderFactory;
    private AdapterHolder.Binder<A, VH> holderBinder;

    public BaseListAdapter(@NonNull Context context) {
        this.context = context;
        this.resources = context.getResources();
        this.layoutInflater = LayoutInflater.from((Context)context);
    }

    @NonNull
    public final Context getContext() {
        return this.context;
    }

    @NonNull
    public final Resources getResources() {
        return this.resources;
    }

    @Override
    public void registerOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.dataSetListeners == null) {
            this.dataSetListeners = new DataSetListeners(this);
        }
        this.dataSetListeners.registerOnDataSetListener(listener);
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        if (this.dataSetListeners != null) {
            this.dataSetListeners.notifyDataSetChanged();
        }
    }

    public void notifyDataSetInvalidated() {
        super.notifyDataSetInvalidated();
        if (this.dataSetListeners != null) {
            this.dataSetListeners.notifyDataSetInvalidated();
        }
    }

    @Override
    public void unregisterOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.dataSetListeners != null) {
            this.dataSetListeners.unregisterOnDataSetListener(listener);
        }
    }

    @Override
    public void registerOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.dataSetListeners == null) {
            this.dataSetListeners = new DataSetListeners(this);
        }
        this.dataSetListeners.registerOnDataSetActionListener(listener);
    }

    public boolean notifyDataSetActionSelected(int action, int position, @Nullable Object payload) {
        if (position < 0 || position >= this.getItemCount()) {
            return false;
        }
        if (this.onDataSetActionSelected(action, position, payload)) {
            return true;
        }
        return this.dataSetListeners != null && this.dataSetListeners.notifyDataSetActionSelected(action, position, payload);
    }

    protected boolean onDataSetActionSelected(int action, int position, @Nullable Object payload) {
        return false;
    }

    @Override
    public void unregisterOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.dataSetListeners != null) {
            this.dataSetListeners.unregisterOnDataSetActionListener(listener);
        }
    }

    public final int getCount() {
        return this.getItemCount();
    }

    @Override
    public boolean hasItemAt(int position) {
        return position >= 0 && position < this.getItemCount();
    }

    @Override
    public long getItemId(int position) {
        return this.hasItemAt(position) ? (long)position : -1L;
    }

    @Override
    public void setHolderFactory(@Nullable AdapterHolder.Factory<VH> factory) {
        this.holderFactory = factory;
    }

    @Override
    @Nullable
    public AdapterHolder.Factory<VH> getHolderFactory() {
        return this.holderFactory;
    }

    @Override
    public void setHolderBinder(@Nullable AdapterHolder.Binder<A, VH> binder) {
        this.holderBinder = binder;
    }

    @Override
    @Nullable
    public AdapterHolder.Binder<A, VH> getHolderBinder() {
        return this.holderBinder;
    }

    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        ViewHolder viewHolder;
        View view = convertView;
        if (view == null) {
            viewHolder = this.onCreateViewHolder(parent, this.getItemViewType(position));
            view = viewHolder.itemView;
            view.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)view.getTag();
        }
        viewHolder.updateAdapterPosition(position);
        this.onBindViewHolder(viewHolder, position);
        return view;
    }

    @NonNull
    protected VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.holderFactory == null) {
            throw AdapterExceptions.noHolderFactoryAttached(this);
        }
        return (VH)((ViewHolder)this.holderFactory.createHolder(parent, viewType));
    }

    @NonNull
    public View inflateView(@LayoutRes int resource, @Nullable ViewGroup parent) {
        return this.layoutInflater.inflate(resource, parent, false);
    }

    protected void onBindViewHolder(@NonNull VH viewHolder, int position) {
        if (this.holderBinder == null) {
            throw AdapterExceptions.noHolderBinderAttached(this);
        }
        this.holderBinder.bindHolder(this, viewHolder, position, Collections.EMPTY_LIST);
    }

    @Override
    @CallSuper
    @NonNull
    public Parcelable saveInstanceState() {
        return AdapterSavedState.EMPTY_STATE;
    }

    @Override
    @CallSuper
    public void restoreInstanceState(@NonNull Parcelable savedState) {
    }
}

