/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter.module;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import universum.studios.android.widget.adapter.AdapterSavedState;
import universum.studios.android.widget.adapter.module.AdapterModule;

public class SelectionModule
extends AdapterModule {
    public static final int SINGLE = 1;
    public static final int MULTIPLE = 2;
    private static final int INITIAL_CAPACITY_SINGLE = 1;
    private static final int INITIAL_CAPACITY_MULTI = 10;
    private int mode = 1;
    private List<Long> selection;

    public void setMode(int mode) {
        if (this.mode != mode) {
            this.mode = mode;
            if (this.selection != null && !this.selection.isEmpty()) {
                this.selection = null;
                this.notifyAdapter();
            }
        }
    }

    public int getMode() {
        return this.mode;
    }

    private void assertInMultipleSelectionModeOrThrow() {
        if (this.mode != 2) {
            throw new IllegalStateException("Not in MULTIPLE selection mode.");
        }
    }

    public int toggleSelection(long id2) {
        this.setSelected(id2, !this.isSelected(id2));
        return this.getSelectionSize();
    }

    public void setSelected(long id2, boolean selected) {
        if (selected) {
            if (this.mode == 1) {
                this.clearSelection(false);
            }
            this.select(id2);
        } else {
            this.deselect(id2);
        }
        this.notifyAdapter();
    }

    public void selectAll() {
        this.assertAttachedToAdapterOrThrow();
        this.selectRange(0, this.adapter.getItemCount());
    }

    public void selectRange(int startPosition, int count) {
        this.assertInMultipleSelectionModeOrThrow();
        this.assertAttachedToAdapterOrThrow();
        int n = this.adapter.getItemCount();
        if (startPosition + count > n) {
            throw new IndexOutOfBoundsException("Incorrect count(" + count + ") for start position(" + startPosition + "). Adapter has only " + n + " items.");
        }
        for (int i = startPosition; i < startPosition + count; ++i) {
            this.select(this.adapter.getItemId(i));
        }
        this.notifyAdapter();
    }

    public void setSelection(@Nullable List<Long> selection) {
        this.selection = selection == null ? null : new ArrayList<Long>(selection);
    }

    public boolean isSelected(long id2) {
        return this.selection != null && this.selection.contains(id2);
    }

    @NonNull
    public List<Long> getSelection() {
        return this.selection == null ? Collections.emptyList() : new ArrayList<Long>(this.selection);
    }

    public int getSelectionSize() {
        return this.selection == null ? 0 : this.selection.size();
    }

    public void clearSelection() {
        this.clearSelection(true);
    }

    protected final void clearSelection(boolean notify) {
        if (this.selection != null) {
            this.selection.clear();
            if (notify) {
                this.notifyAdapter();
            }
        }
    }

    public void clearSelectionInRange(int startPosition, int count) {
        this.assertInMultipleSelectionModeOrThrow();
        this.assertAttachedToAdapterOrThrow();
        int n = this.adapter.getItemCount();
        if (startPosition + count > n) {
            throw new IndexOutOfBoundsException("Incorrect count(" + count + ") for start position(" + startPosition + "). Adapter has only " + n + " items.");
        }
        for (int i = startPosition; i < startPosition + count; ++i) {
            this.deselect(this.adapter.getItemId(i));
        }
        this.notifyAdapter();
    }

    protected final void select(long id2) {
        if (this.selection == null) {
            this.selection = new ArrayList<Long>(this.mode == 1 ? 1 : 10);
        }
        if (!this.selection.contains(id2)) {
            this.selection.add(id2);
        }
    }

    protected final void deselect(long id2) {
        if (this.selection != null) {
            this.selection.remove(id2);
        }
    }

    @Override
    public boolean requiresStateSaving() {
        return this.selection != null && !this.selection.isEmpty();
    }

    @Override
    @CallSuper
    @NonNull
    public Parcelable saveInstanceState() {
        SavedState state = new SavedState(super.saveInstanceState());
        state.mode = this.mode;
        if (this.selection != null && !this.selection.isEmpty()) {
            long[] selectionArray = new long[this.selection.size()];
            for (int i = 0; i < this.selection.size(); ++i) {
                selectionArray[i] = this.selection.get(i);
            }
            state.selection = selectionArray;
        }
        return state;
    }

    @Override
    @CallSuper
    public void restoreInstanceState(@NonNull Parcelable savedState) {
        if (!(savedState instanceof SavedState)) {
            super.restoreInstanceState(savedState);
            return;
        }
        SavedState state = (SavedState)savedState;
        super.restoreInstanceState(state.getSuperState());
        this.mode = state.mode;
        if (state.selection != null) {
            if (this.selection == null) {
                this.selection = new ArrayList<Long>(state.selection.length);
            }
            for (long id2 : state.selection) {
                this.selection.add(id2);
            }
        }
    }

    public static class SavedState
    extends AdapterSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(@NonNull Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        int mode = 1;
        long[] selection;

        protected SavedState(@NonNull Parcelable superState) {
            super(superState);
        }

        protected SavedState(@NonNull Parcel source) {
            super(source);
            this.mode = source.readInt();
            this.selection = source.createLongArray();
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mode);
            dest.writeLongArray(this.selection);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SelectionMode {
    }
}

