/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter.module;

import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import android.view.ViewGroup;
import android.widget.TextView;
import universum.studios.android.widget.adapter.module.AdapterModule;

public abstract class HeadersModule<VH, H extends Header>
extends AdapterModule {
    private final SparseArray<H> headers = new SparseArray(10);
    private int headerStyleAttr = 16842884;

    public boolean isEmpty() {
        return this.headers.size() == 0;
    }

    public int size() {
        return this.headers.size();
    }

    protected void putHeader(int position, @NonNull H header) {
        this.headers.append(position, header);
    }

    public boolean isHeaderAt(int position) {
        return this.headers.get(position) != null;
    }

    @Nullable
    public H getHeader(int position) {
        return (H)((Header)this.headers.get(position));
    }

    @NonNull
    public SparseArray<H> getHeaders() {
        return this.headers;
    }

    @Nullable
    protected H removeHeader(int position) {
        Header header = (Header)this.headers.get(position);
        this.headers.remove(position);
        return (H)header;
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public int correctPosition(int position) {
        return position - this.countHeadersBeforePosition(position);
    }

    public int countHeadersBeforePosition(int position) {
        int count = 0;
        for (int i = 0; i < this.headers.size() && this.headers.keyAt(i) < position; ++i) {
            ++count;
        }
        return count;
    }

    public void setHeaderStyleAttr(@AttrRes int styleAttr) {
        this.headerStyleAttr = styleAttr;
    }

    @AttrRes
    public int getHeaderStyleAttr() {
        return this.headerStyleAttr;
    }

    @NonNull
    public abstract VH createViewHolder(@NonNull ViewGroup var1, int var2);

    @NonNull
    public final SimpleHeaderHolder createSimpleHeaderHolder(@NonNull ViewGroup parent) {
        return new SimpleHeaderHolder(new TextView(parent.getContext(), null, this.headerStyleAttr));
    }

    public abstract void bindViewHolder(@NonNull VH var1, int var2);

    public static final class SimpleHeaderHolder {
        final TextView headerView;

        SimpleHeaderHolder(TextView headerView) {
            this.headerView = headerView;
        }

        public void bind(@NonNull Header header) {
            this.headerView.setText(header.getText());
        }
    }

    public static class SimpleHeader
    implements Header {
        private final CharSequence text;

        public SimpleHeader(@NonNull CharSequence text) {
            this.text = text;
        }

        @Override
        @NonNull
        public CharSequence getText() {
            return this.text;
        }

        public String toString() {
            return this.text.toString();
        }
    }

    public static interface Header {
        @NonNull
        public CharSequence getText();
    }
}

