/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import universum.studios.android.widget.adapter.OnDataSetSwapListener;

public final class SwappableDataSetAdapterListeners<D> {
    private List<OnDataSetSwapListener<D>> listeners;

    public void registerOnDataSetSwapListener(@NonNull OnDataSetSwapListener<D> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<OnDataSetSwapListener<D>>(1);
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected void notifyDataSetSwapStarted(@Nullable D dataSet) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (OnDataSetSwapListener<D> listener : this.listeners) {
                listener.onDataSetSwapStarted(dataSet);
            }
        }
    }

    protected void notifyDataSetSwapFinished(@Nullable D dataSet) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (OnDataSetSwapListener<D> listener : this.listeners) {
                listener.onDataSetSwapFinished(dataSet);
            }
        }
    }

    public void unregisterOnDataSetSwapListener(@NonNull OnDataSetSwapListener<D> listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public boolean isEmpty() {
        return this.listeners == null || this.listeners.isEmpty();
    }
}

