/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import universum.studios.android.widget.adapter.OnDataSetSwapListener;

public interface OnAdapterDataSetSwapListener<A, D> {
    public void onDataSetSwapStarted(@NonNull A var1, @Nullable D var2);

    public void onDataSetSwapFinished(@NonNull A var1, @Nullable D var2);

    public static final class Delegate<A, D>
    implements OnDataSetSwapListener<D> {
        final A adapter;
        final OnAdapterDataSetSwapListener<A, D> delegateListener;

        private Delegate(A adapter, OnAdapterDataSetSwapListener<A, D> listener) {
            this.adapter = adapter;
            this.delegateListener = listener;
        }

        @NonNull
        public static <A, D> Delegate<A, D> create(@NonNull A adapter, @NonNull OnAdapterDataSetSwapListener<A, D> listener) {
            return new Delegate<A, D>(adapter, listener);
        }

        @Override
        public void onDataSetSwapStarted(@Nullable D data) {
            this.delegateListener.onDataSetSwapStarted(this.adapter, data);
        }

        @Override
        public void onDataSetSwapFinished(@Nullable D data) {
            this.delegateListener.onDataSetSwapFinished(this.adapter, data);
        }
    }
}

