/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import universum.studios.android.widget.adapter.DataSet;
import universum.studios.android.widget.adapter.OnDataSetActionListener;
import universum.studios.android.widget.adapter.OnDataSetListener;

public final class DataSetListeners {
    private final DataSet dataSet;
    private List<OnDataSetListener> listeners;
    private List<OnDataSetActionListener> actionListeners;

    public DataSetListeners(@NonNull DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public void registerOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<OnDataSetListener>(1);
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void notifyDataSetChanged() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (OnDataSetListener listener : this.listeners) {
                listener.onDataSetChanged();
            }
        }
    }

    public void notifyDataSetInvalidated() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (OnDataSetListener listener : this.listeners) {
                listener.onDataSetInvalidated();
            }
        }
    }

    public void unregisterOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void registerOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<OnDataSetActionListener>(1);
        }
        if (!this.actionListeners.contains(listener)) {
            this.actionListeners.add(listener);
        }
    }

    public boolean notifyDataSetActionSelected(int action, int position, Object payload) {
        if (this.actionListeners != null && !this.actionListeners.isEmpty()) {
            long itemId = this.dataSet.getItemId(position);
            for (OnDataSetActionListener listener : this.actionListeners) {
                if (!listener.onDataSetActionSelected(action, position, itemId, payload)) continue;
                return true;
            }
        }
        return false;
    }

    public void unregisterOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(listener);
        }
    }

    public boolean isEmpty() {
        return !(this.listeners != null && !this.listeners.isEmpty() || this.actionListeners != null && !this.actionListeners.isEmpty());
    }
}

