/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.Collections;
import java.util.List;
import universum.studios.android.widget.adapter.AdapterExceptions;
import universum.studios.android.widget.adapter.AdapterSavedState;
import universum.studios.android.widget.adapter.DataSetAdapter;
import universum.studios.android.widget.adapter.DataSetListeners;
import universum.studios.android.widget.adapter.OnDataSetActionListener;
import universum.studios.android.widget.adapter.OnDataSetListener;
import universum.studios.android.widget.adapter.holder.AdapterHolder;

public abstract class BaseRecyclerAdapter<A extends BaseRecyclerAdapter, VH extends RecyclerView.ViewHolder, I>
extends RecyclerView.Adapter<VH>
implements DataSetAdapter<I>,
AdapterHolder.FactoryAdapter<VH>,
AdapterHolder.BinderAdapter<A, VH> {
    @Deprecated
    @NonNull
    protected final Context mContext;
    @Deprecated
    @NonNull
    protected final Resources mResources;
    private final LayoutInflater layoutInflater;
    DataSetListeners dataSetListeners;
    private RecyclerView.AdapterDataObserver dataObserver;
    private AdapterHolder.Factory<VH> holderFactory;
    private AdapterHolder.Binder<A, VH> holderBinder;

    public BaseRecyclerAdapter(@NonNull Context context) {
        this.mContext = context;
        this.mResources = context.getResources();
        this.layoutInflater = LayoutInflater.from((Context)context);
    }

    @NonNull
    public final Context getContext() {
        return this.mContext;
    }

    @NonNull
    public final Resources getResources() {
        return this.mResources;
    }

    @Override
    public void registerOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.dataSetListeners == null) {
            this.dataSetListeners = new DataSetListeners(this);
        }
        this.dataSetListeners.registerOnDataSetListener(listener);
        if (this.dataObserver == null) {
            this.dataObserver = new RecyclerView.AdapterDataObserver(){

                public void onChanged() {
                    BaseRecyclerAdapter.this.dataSetListeners.notifyDataSetChanged();
                }

                public void onItemRangeInserted(int positionStart, int itemCount) {
                    BaseRecyclerAdapter.this.dataSetListeners.notifyDataSetChanged();
                }

                public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
                    BaseRecyclerAdapter.this.dataSetListeners.notifyDataSetChanged();
                }

                public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                    BaseRecyclerAdapter.this.dataSetListeners.notifyDataSetChanged();
                }

                public void onItemRangeRemoved(int positionStart, int itemCount) {
                    BaseRecyclerAdapter.this.dataSetListeners.notifyDataSetChanged();
                }
            };
            this.registerAdapterDataObserver(this.dataObserver);
        }
    }

    @Override
    public void unregisterOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.dataSetListeners != null) {
            this.dataSetListeners.unregisterOnDataSetListener(listener);
            if (this.dataObserver != null && this.dataSetListeners.isEmpty()) {
                this.unregisterAdapterDataObserver(this.dataObserver);
                this.dataObserver = null;
            }
        }
    }

    @Override
    public void registerOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.dataSetListeners == null) {
            this.dataSetListeners = new DataSetListeners(this);
        }
        this.dataSetListeners.registerOnDataSetActionListener(listener);
    }

    public boolean notifyDataSetActionSelected(int action, int position, @Nullable Object payload) {
        if (position < 0 || position >= this.getItemCount()) {
            return false;
        }
        if (this.onDataSetActionSelected(action, position, payload)) {
            return true;
        }
        return this.dataSetListeners != null && this.dataSetListeners.notifyDataSetActionSelected(action, position, payload);
    }

    protected boolean onDataSetActionSelected(int action, int position, @Nullable Object payload) {
        return false;
    }

    @Override
    public void unregisterOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.dataSetListeners != null) {
            this.dataSetListeners.unregisterOnDataSetActionListener(listener);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    @Override
    public boolean isEnabled(int position) {
        return true;
    }

    @Override
    public boolean hasItemAt(int position) {
        return position >= 0 && position < this.getItemCount();
    }

    @Override
    public long getItemId(int position) {
        return this.hasItemAt(position) ? (long)position : -1L;
    }

    @Override
    public void setHolderFactory(@Nullable AdapterHolder.Factory<VH> factory) {
        this.holderFactory = factory;
    }

    @Override
    @Nullable
    public AdapterHolder.Factory<VH> getHolderFactory() {
        return this.holderFactory;
    }

    @Override
    public void setHolderBinder(@Nullable AdapterHolder.Binder<A, VH> binder) {
        this.holderBinder = binder;
    }

    @Override
    @Nullable
    public AdapterHolder.Binder<A, VH> getHolderBinder() {
        return this.holderBinder;
    }

    public VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.holderFactory == null) {
            throw AdapterExceptions.noHolderFactoryAttached(this);
        }
        return (VH)((RecyclerView.ViewHolder)this.holderFactory.createHolder(parent, viewType));
    }

    @NonNull
    public View inflateView(@LayoutRes int resource, @Nullable ViewGroup parent) {
        return this.layoutInflater.inflate(resource, parent, false);
    }

    public void onBindViewHolder(@NonNull VH viewHolder, int position, @NonNull List<Object> payloads) {
        if (this.holderBinder == null) {
            super.onBindViewHolder(viewHolder, position, payloads);
        } else {
            this.holderBinder.bindHolder(this, (AdapterHolder)viewHolder, position, payloads);
        }
    }

    public void onBindViewHolder(@NonNull VH viewHolder, int position) {
        if (this.holderBinder == null) {
            throw AdapterExceptions.noHolderBinderAttached(this);
        }
        this.holderBinder.bindHolder(this, (AdapterHolder)viewHolder, position, Collections.EMPTY_LIST);
    }

    @Override
    @CallSuper
    @NonNull
    public Parcelable saveInstanceState() {
        return AdapterSavedState.EMPTY_STATE;
    }

    @Override
    @CallSuper
    public void restoreInstanceState(@NonNull Parcelable savedState) {
    }
}

