/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter.module;

import android.database.Cursor;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.util.Collection;
import universum.studios.android.widget.adapter.module.HeadersModule;

public abstract class AlphabeticHeaders<VH>
extends HeadersModule<VH, HeadersModule.SimpleHeader> {
    private String lastProcessedLetter = "";

    public <C extends Cursor & AlphabeticItem> void fromAlphabeticCursor(@NonNull C cursor) {
        this.clearHeaders();
        if (cursor.getCount() > 0 && cursor.moveToFirst()) {
            do {
                this.onProcessItem(cursor.getPosition(), cursor);
            } while (cursor.moveToNext());
        }
        this.notifyAdapter();
    }

    public <Item extends AlphabeticItem> void fromAlphabeticCollection(@NonNull Collection<Item> collection) {
        this.clearHeaders();
        if (!collection.isEmpty()) {
            int position = 0;
            for (AlphabeticItem item : collection) {
                this.onProcessItem(position++, item);
            }
        }
        this.notifyAdapter();
    }

    @Override
    @CallSuper
    public void clearHeaders() {
        super.clearHeaders();
        this.lastProcessedLetter = "";
    }

    protected final void onProcessItem(int position, @NonNull AlphabeticItem item) {
        String name = item.getText().toString();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            String firstLetter = name.substring(0, 1);
            if (!firstLetter.equals(this.lastProcessedLetter)) {
                this.putHeader(this.size() + position, new HeadersModule.SimpleHeader(firstLetter));
            }
            this.lastProcessedLetter = firstLetter;
        }
    }

    public static interface AlphabeticItem {
        @NonNull
        public CharSequence getText();
    }
}

