/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter.module;

import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import android.view.ViewGroup;
import android.widget.TextView;
import universum.studios.android.widget.adapter.module.AdapterModule;

public abstract class HeadersModule<VH, H extends Header>
extends AdapterModule {
    private final SparseArray<H> mHeaders = new SparseArray(10);
    private int mHeaderStyleAttr = 16842884;

    public boolean isEmpty() {
        return this.mHeaders.size() == 0;
    }

    public int size() {
        return this.mHeaders.size();
    }

    protected void putHeader(int position, @NonNull H header) {
        this.mHeaders.append(position, header);
    }

    public boolean isHeaderAt(int position) {
        return this.mHeaders.get(position) != null;
    }

    @Nullable
    public H getHeader(int position) {
        return (H)((Header)this.mHeaders.get(position));
    }

    @NonNull
    public SparseArray<H> getHeaders() {
        return this.mHeaders;
    }

    @Nullable
    protected H removeHeader(int position) {
        Header header = (Header)this.mHeaders.get(position);
        this.mHeaders.remove(position);
        return (H)header;
    }

    public void clearHeaders() {
        this.mHeaders.clear();
    }

    public int correctPosition(int position) {
        return position - this.countHeadersBeforePosition(position);
    }

    public int countHeadersBeforePosition(int position) {
        int count = 0;
        for (int i = 0; i < this.mHeaders.size() && this.mHeaders.keyAt(i) < position; ++i) {
            ++count;
        }
        return count;
    }

    public void setHeaderStyleAttr(@AttrRes int styleAttr) {
        this.mHeaderStyleAttr = styleAttr;
    }

    @AttrRes
    public int getHeaderStyleAttr() {
        return this.mHeaderStyleAttr;
    }

    @NonNull
    public abstract VH createViewHolder(@NonNull ViewGroup var1, int var2);

    @NonNull
    public final SimpleHeaderHolder createSimpleHeaderHolder(@NonNull ViewGroup parent) {
        return new SimpleHeaderHolder(new TextView(parent.getContext(), null, this.mHeaderStyleAttr));
    }

    public abstract void bindViewHolder(@NonNull VH var1, int var2);

    public static final class SimpleHeaderHolder {
        final TextView headerView;

        SimpleHeaderHolder(TextView headerView) {
            this.headerView = headerView;
        }

        public void bind(@NonNull Header header) {
            this.headerView.setText(header.getText());
        }
    }

    public static class SimpleHeader
    implements Header {
        private final CharSequence text;

        public SimpleHeader(@NonNull CharSequence text) {
            this.text = text;
        }

        @Override
        @NonNull
        public CharSequence getText() {
            return this.text;
        }

        public String toString() {
            return this.text.toString();
        }
    }

    public static interface Header {
        @NonNull
        public CharSequence getText();
    }
}

