/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import universum.studios.android.widget.adapter.OnDataSetSwapListener;

public final class SwappableDataSetAdapterListeners<D> {
    private List<OnDataSetSwapListener<D>> mListeners;

    public void registerOnDataSetSwapListener(@NonNull OnDataSetSwapListener<D> listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<OnDataSetSwapListener<D>>(1);
        }
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    protected void notifyDataSetSwapStarted(@Nullable D dataSet) {
        if (this.mListeners != null && !this.mListeners.isEmpty()) {
            for (OnDataSetSwapListener<D> listener : this.mListeners) {
                listener.onDataSetSwapStarted(dataSet);
            }
        }
    }

    protected void notifyDataSetSwapFinished(@Nullable D dataSet) {
        if (this.mListeners != null && !this.mListeners.isEmpty()) {
            for (OnDataSetSwapListener<D> listener : this.mListeners) {
                listener.onDataSetSwapFinished(dataSet);
            }
        }
    }

    public void unregisterOnDataSetSwapListener(@NonNull OnDataSetSwapListener<D> listener) {
        if (this.mListeners != null) {
            this.mListeners.remove(listener);
        }
    }

    public boolean isEmpty() {
        return this.mListeners == null || this.mListeners.isEmpty();
    }
}

