/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.RecyclerView;
import java.util.Arrays;
import java.util.List;
import universum.studios.android.widget.adapter.BaseRecyclerAdapter;
import universum.studios.android.widget.adapter.DataSetItemPositionResolver;
import universum.studios.android.widget.adapter.OnDataSetSwapListener;
import universum.studios.android.widget.adapter.SimpleAdapter;
import universum.studios.android.widget.adapter.SimpleAdapterDataSet;
import universum.studios.android.widget.adapter.SwappableDataSetAdapterListeners;

public class SimpleRecyclerAdapter<A extends SimpleRecyclerAdapter, VH extends RecyclerView.ViewHolder, I>
extends BaseRecyclerAdapter<A, VH, I>
implements SimpleAdapter<I> {
    private final SimpleAdapterDataSet<I> mDataSet;
    private SwappableDataSetAdapterListeners<List<I>> mListeners;

    public SimpleRecyclerAdapter(@NonNull Context context) {
        this(context, new SimpleAdapterDataSet());
    }

    public SimpleRecyclerAdapter(@NonNull Context context, @NonNull I[] items) {
        this(context, Arrays.asList(items));
    }

    public SimpleRecyclerAdapter(@NonNull Context context, @NonNull List<I> items) {
        this(context, new SimpleAdapterDataSet<I>(items));
    }

    @VisibleForTesting
    SimpleRecyclerAdapter(Context context, SimpleAdapterDataSet<I> dataSet) {
        super(context);
        this.mDataSet = dataSet;
        this.mDataSet.setItemsCallback(new SimpleAdapterDataSet.ItemsCallback(){

            @Override
            public void onItemRangeInserted(int positionStart, int itemCount) {
                SimpleRecyclerAdapter.this.notifyItemRangeInserted(positionStart, itemCount);
            }

            @Override
            public void onItemRangeChanged(int positionStart, int itemCount) {
                SimpleRecyclerAdapter.this.notifyItemRangeChanged(positionStart, itemCount);
            }

            @Override
            public void onItemMoved(int fromPosition, int toPosition) {
                SimpleRecyclerAdapter.this.notifyItemMoved(fromPosition, toPosition);
            }

            @Override
            public void onItemRangeRemoved(int positionStart, int itemCount) {
                SimpleRecyclerAdapter.this.notifyItemRangeRemoved(positionStart, itemCount);
            }
        });
        this.mDataSet.setItemPositionResolver(new DataSetItemPositionResolver(this));
    }

    @Override
    public void registerOnDataSetSwapListener(@NonNull OnDataSetSwapListener<List<I>> listener) {
        if (this.mListeners == null) {
            this.mListeners = new SwappableDataSetAdapterListeners();
        }
        this.mListeners.registerOnDataSetSwapListener(listener);
    }

    @Override
    public void unregisterOnDataSetSwapListener(@NonNull OnDataSetSwapListener<List<I>> listener) {
        if (this.mListeners != null) {
            this.mListeners.unregisterOnDataSetSwapListener(listener);
        }
    }

    @Override
    public void changeItems(@Nullable List<I> items) {
        this.swapItems(items);
    }

    @Override
    @Nullable
    public List<I> swapItems(@Nullable List<I> items) {
        this.notifyItemsSwapStarted(items);
        List<I> oldItems = this.onSwapItems(items);
        this.notifyItemsSwapFinished(items);
        this.notifyDataSetChanged();
        return oldItems;
    }

    protected final void notifyItemsSwapStarted(@Nullable List<I> items) {
        if (this.mListeners != null) {
            this.mListeners.notifyDataSetSwapStarted(items);
        }
    }

    @Nullable
    protected List<I> onSwapItems(@Nullable List<I> items) {
        return this.mDataSet.swapItems(items);
    }

    protected final void notifyItemsSwapFinished(@Nullable List<I> items) {
        if (this.mListeners != null) {
            this.mListeners.notifyDataSetSwapFinished(items);
        }
    }

    @Override
    public void insertItem(@NonNull I item) {
        this.mDataSet.insertItem(item);
    }

    @Override
    public void insertItem(int position, @NonNull I item) {
        this.mDataSet.insertItem(position, item);
    }

    @Override
    public void insertItems(@NonNull List<I> items) {
        this.mDataSet.insertItems(items);
    }

    @Override
    public void insertItems(int positionStart, @NonNull List<I> items) {
        this.mDataSet.insertItems(positionStart, items);
    }

    @Override
    @NonNull
    public I swapItem(int position, @NonNull I item) {
        return this.mDataSet.swapItem(position, item);
    }

    @Override
    @NonNull
    public I swapItemById(long itemId, @NonNull I item) {
        return this.mDataSet.swapItemById(itemId, item);
    }

    @Override
    public void moveItem(int fromPosition, int toPosition) {
        this.mDataSet.moveItem(fromPosition, toPosition);
    }

    @Override
    @NonNull
    public I removeItem(int position) {
        return this.mDataSet.removeItem(position);
    }

    @Override
    public int removeItem(@NonNull I item) {
        return this.mDataSet.removeItem(item);
    }

    @Override
    @NonNull
    public I removeItemById(long itemId) {
        return this.mDataSet.removeItemById(itemId);
    }

    @Override
    @NonNull
    public List<I> removeItems(int positionStart, int itemCount) {
        return this.mDataSet.removeItems(positionStart, itemCount);
    }

    @Override
    @Nullable
    public List<I> getItems() {
        return this.mDataSet.getItems();
    }

    @Override
    public int getItemCount() {
        return this.mDataSet.getItemCount();
    }

    @Override
    public boolean hasItemAt(int position) {
        return this.mDataSet.hasItemAt(position);
    }

    @Override
    @NonNull
    public I getItem(int position) {
        return this.mDataSet.getItem(position);
    }
}

