/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import universum.studios.android.widget.adapter.AdaptersLogging;
import universum.studios.android.widget.adapter.ItemPositionResolver;
import universum.studios.android.widget.adapter.SimpleDataSet;

class SimpleAdapterDataSet<I>
implements SimpleDataSet<I> {
    private static final String TAG = "SimpleAdapterDataSet";
    private List<I> mItems;
    private ItemsCallback mItemsCallback;
    private ItemPositionResolver mItemPositionResolver;

    SimpleAdapterDataSet() {
        this(null);
    }

    SimpleAdapterDataSet(List<I> items) {
        this.mItems = items;
    }

    void setItemsCallback(ItemsCallback callback) {
        this.mItemsCallback = callback;
    }

    private void notifyItemRangeInserted(int positionStart, int itemCount) {
        if (this.mItemsCallback != null) {
            this.mItemsCallback.onItemRangeInserted(positionStart, itemCount);
        }
    }

    private void notifyItemRangeChanged(int positionStart, int itemCount) {
        if (this.mItemsCallback != null) {
            this.mItemsCallback.onItemRangeChanged(positionStart, itemCount);
        }
    }

    private void notifyItemMoved(int fromPosition, int toPosition) {
        if (this.mItemsCallback != null) {
            this.mItemsCallback.onItemMoved(fromPosition, toPosition);
        }
    }

    private void notifyItemRangeRemoved(int positionStart, int itemCount) {
        if (this.mItemsCallback != null) {
            this.mItemsCallback.onItemRangeRemoved(positionStart, itemCount);
        }
    }

    void setItemPositionResolver(ItemPositionResolver resolver) {
        this.mItemPositionResolver = resolver;
    }

    private int resolvePositionForItemId(long itemId) {
        if (this.mItemPositionResolver == null) {
            throw new IllegalStateException("No position resolver for item id specified!");
        }
        return this.mItemPositionResolver.resolveItemPosition(itemId);
    }

    List<I> swapItems(List<I> items) {
        List<I> oldItems = this.mItems;
        this.mItems = items;
        return oldItems;
    }

    List<I> getItems() {
        return this.mItems;
    }

    @Override
    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    @Override
    public int getItemCount() {
        return this.mItems == null ? 0 : this.mItems.size();
    }

    @Override
    public void insertItem(@NonNull I item) {
        this.insertItem(this.getItemCount(), item);
    }

    @Override
    public void insertItem(int position, @NonNull I item) {
        if (this.mItems == null) {
            this.mItems = new ArrayList<I>();
            this.mItems.add(item);
            AdaptersLogging.d(TAG, "Inserted item at position(0).");
            this.notifyItemRangeInserted(0, 1);
        } else {
            this.mItems.add(position, item);
            AdaptersLogging.d(TAG, "Inserted item at position(" + position + ").");
            this.notifyItemRangeInserted(position, 1);
        }
    }

    @Override
    public void insertItems(@NonNull List<I> items) {
        this.insertItems(this.getItemCount(), items);
    }

    @Override
    public void insertItems(int positionStart, @NonNull List<I> items) {
        int itemsSize = items.size();
        if (this.mItems == null) {
            this.mItems = new ArrayList<I>(items);
            AdaptersLogging.d(TAG, "Inserted items from start position(0) in count(" + itemsSize + ").");
            this.notifyItemRangeInserted(0, itemsSize);
        } else {
            this.mItems.addAll(positionStart, items);
            AdaptersLogging.d(TAG, "Inserted items from start position(" + positionStart + ") in count(" + itemsSize + ").");
            this.notifyItemRangeInserted(positionStart, itemsSize);
        }
    }

    @Override
    @NonNull
    public I swapItemById(long itemId, @NonNull I item) {
        int position = this.resolvePositionForItemId(itemId);
        if (position == -1) {
            throw new AssertionError((Object)("No item to be swapped with id(" + itemId + ") found!"));
        }
        return this.swapItem(position, item);
    }

    @Override
    @NonNull
    public I swapItem(int position, @NonNull I item) {
        Assert.assertTrue((String)("No item to be swapped at position(" + position + ") found!"), (boolean)this.hasItemAt(position));
        I oldItem = this.mItems.set(position, item);
        AdaptersLogging.d(TAG, "Swapped item at position(" + position + ").");
        this.notifyItemRangeChanged(position, 1);
        return oldItem;
    }

    @Override
    public void moveItem(int fromPosition, int toPosition) {
        Assert.assertTrue((String)("No item to be moved from position(" + fromPosition + ") to position(" + toPosition + ") found!"), (boolean)this.hasItemAt(fromPosition));
        Assert.assertTrue((String)("No item to be moved from position(" + toPosition + ") to position(" + fromPosition + ") found!"), (boolean)this.hasItemAt(toPosition));
        this.mItems.set(fromPosition, this.mItems.set(toPosition, this.mItems.get(fromPosition)));
        AdaptersLogging.d(TAG, "Moved item from position(" + fromPosition + ") to position(" + toPosition + ").");
        this.notifyItemMoved(fromPosition, toPosition);
    }

    @Override
    public int removeItem(@NonNull I item) {
        int position;
        int n = position = this.mItems == null ? -1 : this.mItems.indexOf(item);
        if (position == -1) {
            throw new AssertionError((Object)("No item(" + item + ") to be removed found!"));
        }
        this.removeItem(position);
        return position;
    }

    @Override
    @NonNull
    public I removeItemById(long itemId) {
        int position = this.resolvePositionForItemId(itemId);
        if (position == -1) {
            throw new AssertionError((Object)("No item to be removed with id(" + itemId + ") found!"));
        }
        return this.removeItem(position);
    }

    @Override
    @NonNull
    public I removeItem(int position) {
        if (this.hasItemAt(position)) {
            I item = this.mItems.remove(position);
            AdaptersLogging.d(TAG, "Removed item at position(" + position + ").");
            this.notifyItemRangeRemoved(position, 1);
            return item;
        }
        throw new AssertionError((Object)("No item to be removed at position(" + position + ") found!"));
    }

    @Override
    @NonNull
    public List<I> removeItems(int positionStart, int itemCount) {
        int itemsSize = this.mItems.size();
        if (positionStart < 0 || positionStart + itemCount > itemsSize) {
            throw new IndexOutOfBoundsException("Starting position(" + positionStart + ") and/or item count(" + itemCount + ") are out of range (positionStart < 0 || positionStart + itemCount > " + itemsSize + ")!");
        }
        ArrayList<I> items = new ArrayList<I>(itemCount);
        for (int i = positionStart + itemCount - 1; i >= positionStart; --i) {
            items.add(0, this.mItems.remove(i));
        }
        AdaptersLogging.d(TAG, "Removed items from start position(" + positionStart + ") in count(" + itemCount + ").");
        this.notifyItemRangeRemoved(positionStart, itemCount);
        return items;
    }

    @Override
    public boolean hasItemAt(int position) {
        return position >= 0 && position < this.getItemCount();
    }

    @Override
    public boolean isEnabled(int position) {
        return true;
    }

    @Override
    public boolean hasStableIds() {
        return false;
    }

    @Override
    public long getItemId(int position) {
        return this.hasItemAt(position) ? (long)position : -1L;
    }

    @Override
    @NonNull
    public I getItem(int position) {
        if (!this.hasItemAt(position)) {
            throw new IndexOutOfBoundsException("Requested item at invalid position(" + position + "). Data set has items in count of(" + this.getItemCount() + ").");
        }
        return this.mItems.get(position);
    }

    static class SimpleItemsCallback
    implements ItemsCallback {
        SimpleItemsCallback() {
        }

        @Override
        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.onItemsChanged();
        }

        @Override
        public void onItemRangeChanged(int positionStart, int itemCount) {
            this.onItemsChanged();
        }

        @Override
        public void onItemMoved(int fromPosition, int toPosition) {
            this.onItemsChanged();
        }

        @Override
        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.onItemsChanged();
        }

        void onItemsChanged() {
        }
    }

    static interface ItemsCallback {
        public void onItemRangeInserted(int var1, int var2);

        public void onItemRangeChanged(int var1, int var2);

        public void onItemMoved(int var1, int var2);

        public void onItemRangeRemoved(int var1, int var2);
    }
}

