/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import universum.studios.android.widget.adapter.DataSet;
import universum.studios.android.widget.adapter.OnDataSetActionListener;
import universum.studios.android.widget.adapter.OnDataSetListener;

public final class DataSetListeners {
    private final DataSet mDataSet;
    private List<OnDataSetListener> mListeners;
    private List<OnDataSetActionListener> mActionListeners;

    public DataSetListeners(@NonNull DataSet dataSet) {
        this.mDataSet = dataSet;
    }

    public void registerOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<OnDataSetListener>(1);
        }
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void notifyDataSetChanged() {
        if (this.mListeners != null && !this.mListeners.isEmpty()) {
            for (OnDataSetListener listener : this.mListeners) {
                listener.onDataSetChanged();
            }
        }
    }

    public void notifyDataSetInvalidated() {
        if (this.mListeners != null && !this.mListeners.isEmpty()) {
            for (OnDataSetListener listener : this.mListeners) {
                listener.onDataSetInvalidated();
            }
        }
    }

    public void unregisterOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.mListeners != null) {
            this.mListeners.remove(listener);
        }
    }

    public void registerOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.mActionListeners == null) {
            this.mActionListeners = new ArrayList<OnDataSetActionListener>(1);
        }
        if (!this.mActionListeners.contains(listener)) {
            this.mActionListeners.add(listener);
        }
    }

    public boolean notifyDataSetActionSelected(int action, int position, Object payload) {
        if (this.mActionListeners != null && !this.mActionListeners.isEmpty()) {
            long itemId = this.mDataSet.getItemId(position);
            for (OnDataSetActionListener listener : this.mActionListeners) {
                if (!listener.onDataSetActionSelected(action, position, itemId, payload)) continue;
                return true;
            }
        }
        return false;
    }

    public void unregisterOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.mActionListeners != null) {
            this.mActionListeners.remove(listener);
        }
    }

    public boolean isEmpty() {
        return !(this.mListeners != null && !this.mListeners.isEmpty() || this.mActionListeners != null && !this.mActionListeners.isEmpty());
    }
}

