/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import java.util.Collections;
import universum.studios.android.widget.adapter.BaseListAdapter;
import universum.studios.android.widget.adapter.holder.AdapterHolder;
import universum.studios.android.widget.adapter.holder.ViewHolder;

public abstract class BaseSpinnerAdapter<A extends BaseSpinnerAdapter, VH extends ViewHolder, DVH extends ViewHolder, I>
extends BaseListAdapter<A, VH, I> {
    private int mSelectedPosition = -1;
    private AdapterHolder.Factory<DVH> mDropDownHolderFactory;
    private AdapterHolder.Binder<A, DVH> mDropDownHolderBinder;

    public BaseSpinnerAdapter(@NonNull Context context) {
        super(context);
    }

    public void setDropDownHolderFactory(@Nullable AdapterHolder.Factory<DVH> factory) {
        this.mDropDownHolderFactory = factory;
    }

    @Nullable
    public AdapterHolder.Factory<DVH> getDropDownHolderFactory() {
        return this.mDropDownHolderFactory;
    }

    public void setDropDownHolderBinder(@Nullable AdapterHolder.Binder<A, DVH> binder) {
        this.mDropDownHolderBinder = binder;
    }

    @Nullable
    public AdapterHolder.Binder<A, DVH> getDropDownHolderBinder() {
        return this.mDropDownHolderBinder;
    }

    @Nullable
    public I getSelectedItem() {
        return (I)(this.mSelectedPosition == -1 ? null : this.getItem(this.mSelectedPosition));
    }

    public int getSelectedPosition() {
        return this.mSelectedPosition;
    }

    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        this.mSelectedPosition = position;
        return super.getView(this.mSelectedPosition, convertView, parent);
    }

    public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        ViewHolder viewHolder;
        View view = convertView;
        if (view == null) {
            viewHolder = this.onCreateDropDownViewHolder(parent, this.getItemViewType(position));
            view = viewHolder.itemView;
            view.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)view.getTag();
        }
        viewHolder.updateAdapterPosition(position);
        this.onBindDropDownViewHolder(viewHolder, position);
        return view;
    }

    @NonNull
    protected DVH onCreateDropDownViewHolder(@NonNull ViewGroup parent, int viewType) {
        return (DVH)(this.mDropDownHolderFactory == null ? this.onCreateViewHolder(parent, viewType) : (ViewHolder)this.mDropDownHolderFactory.createHolder(parent, viewType));
    }

    protected void onBindDropDownViewHolder(@NonNull DVH viewHolder, int position) {
        if (this.mDropDownHolderBinder == null) {
            this.onBindViewHolder(viewHolder, position);
        } else {
            this.mDropDownHolderBinder.bindHolder(this, viewHolder, position, Collections.EMPTY_LIST);
        }
    }
}

