/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.Collections;
import java.util.List;
import universum.studios.android.widget.adapter.AdapterExceptions;
import universum.studios.android.widget.adapter.AdapterSavedState;
import universum.studios.android.widget.adapter.DataSetAdapter;
import universum.studios.android.widget.adapter.DataSetListeners;
import universum.studios.android.widget.adapter.OnDataSetActionListener;
import universum.studios.android.widget.adapter.OnDataSetListener;
import universum.studios.android.widget.adapter.holder.AdapterHolder;

public abstract class BaseRecyclerAdapter<A extends BaseRecyclerAdapter, VH extends RecyclerView.ViewHolder, I>
extends RecyclerView.Adapter<VH>
implements DataSetAdapter<I>,
AdapterHolder.FactoryAdapter<VH>,
AdapterHolder.BinderAdapter<A, VH> {
    @NonNull
    protected final Context mContext;
    @NonNull
    protected final Resources mResources;
    private final LayoutInflater mLayoutInflater;
    DataSetListeners mDataSetListeners;
    private RecyclerView.AdapterDataObserver mDataObserver;
    private AdapterHolder.Factory<VH> mHolderFactory;
    private AdapterHolder.Binder<A, VH> mHolderBinder;

    public BaseRecyclerAdapter(@NonNull Context context) {
        this.mContext = context;
        this.mResources = context.getResources();
        this.mLayoutInflater = LayoutInflater.from((Context)context);
    }

    @Override
    public void registerOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.mDataSetListeners == null) {
            this.mDataSetListeners = new DataSetListeners(this);
        }
        this.mDataSetListeners.registerOnDataSetListener(listener);
        if (this.mDataObserver == null) {
            this.mDataObserver = new RecyclerView.AdapterDataObserver(){

                public void onChanged() {
                    BaseRecyclerAdapter.this.mDataSetListeners.notifyDataSetChanged();
                }

                public void onItemRangeInserted(int positionStart, int itemCount) {
                    BaseRecyclerAdapter.this.mDataSetListeners.notifyDataSetChanged();
                }

                public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
                    BaseRecyclerAdapter.this.mDataSetListeners.notifyDataSetChanged();
                }

                public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                    BaseRecyclerAdapter.this.mDataSetListeners.notifyDataSetChanged();
                }

                public void onItemRangeRemoved(int positionStart, int itemCount) {
                    BaseRecyclerAdapter.this.mDataSetListeners.notifyDataSetChanged();
                }
            };
            this.registerAdapterDataObserver(this.mDataObserver);
        }
    }

    @Override
    public void unregisterOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.mDataSetListeners != null) {
            this.mDataSetListeners.unregisterOnDataSetListener(listener);
            if (this.mDataObserver != null && this.mDataSetListeners.isEmpty()) {
                this.unregisterAdapterDataObserver(this.mDataObserver);
                this.mDataObserver = null;
            }
        }
    }

    @Override
    public void registerOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.mDataSetListeners == null) {
            this.mDataSetListeners = new DataSetListeners(this);
        }
        this.mDataSetListeners.registerOnDataSetActionListener(listener);
    }

    public boolean notifyDataSetActionSelected(int action, int position, @Nullable Object payload) {
        if (position < 0 || position >= this.getItemCount()) {
            return false;
        }
        if (this.onDataSetActionSelected(action, position, payload)) {
            return true;
        }
        return this.mDataSetListeners != null && this.mDataSetListeners.notifyDataSetActionSelected(action, position, payload);
    }

    protected boolean onDataSetActionSelected(int action, int position, @Nullable Object payload) {
        return false;
    }

    @Override
    public void unregisterOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.mDataSetListeners != null) {
            this.mDataSetListeners.unregisterOnDataSetActionListener(listener);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    @Override
    public boolean isEnabled(int position) {
        return true;
    }

    @Override
    public boolean hasItemAt(int position) {
        return position >= 0 && position < this.getItemCount();
    }

    @Override
    public long getItemId(int position) {
        return this.hasItemAt(position) ? (long)position : -1L;
    }

    @Override
    public void setHolderFactory(@Nullable AdapterHolder.Factory<VH> factory) {
        this.mHolderFactory = factory;
    }

    @Override
    @Nullable
    public AdapterHolder.Factory<VH> getHolderFactory() {
        return this.mHolderFactory;
    }

    @Override
    public void setHolderBinder(@Nullable AdapterHolder.Binder<A, VH> binder) {
        this.mHolderBinder = binder;
    }

    @Override
    @Nullable
    public AdapterHolder.Binder<A, VH> getHolderBinder() {
        return this.mHolderBinder;
    }

    public VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.mHolderFactory == null) {
            throw AdapterExceptions.noHolderFactoryAttached(this);
        }
        return (VH)((RecyclerView.ViewHolder)this.mHolderFactory.createHolder(parent, viewType));
    }

    @NonNull
    public View inflateView(@LayoutRes int resource, @Nullable ViewGroup parent) {
        return this.mLayoutInflater.inflate(resource, parent, false);
    }

    public void onBindViewHolder(@NonNull VH viewHolder, int position, @NonNull List<Object> payloads) {
        if (this.mHolderBinder == null) {
            super.onBindViewHolder(viewHolder, position, payloads);
        } else {
            this.mHolderBinder.bindHolder(this, (AdapterHolder)viewHolder, position, payloads);
        }
    }

    public void onBindViewHolder(@NonNull VH viewHolder, int position) {
        if (this.mHolderBinder == null) {
            throw AdapterExceptions.noHolderBinderAttached(this);
        }
        this.mHolderBinder.bindHolder(this, (AdapterHolder)viewHolder, position, Collections.EMPTY_LIST);
    }

    @Override
    @NonNull
    @CallSuper
    public Parcelable saveInstanceState() {
        return AdapterSavedState.EMPTY_STATE;
    }

    @Override
    @CallSuper
    public void restoreInstanceState(@NonNull Parcelable savedState) {
    }
}

