/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.Collections;
import universum.studios.android.widget.adapter.AdapterExceptions;
import universum.studios.android.widget.adapter.AdapterSavedState;
import universum.studios.android.widget.adapter.DataSetAdapter;
import universum.studios.android.widget.adapter.DataSetListeners;
import universum.studios.android.widget.adapter.OnDataSetActionListener;
import universum.studios.android.widget.adapter.OnDataSetListener;
import universum.studios.android.widget.adapter.holder.AdapterHolder;
import universum.studios.android.widget.adapter.holder.ViewHolder;

public abstract class BaseListAdapter<A extends BaseListAdapter, VH extends ViewHolder, I>
extends BaseAdapter
implements DataSetAdapter<I>,
AdapterHolder.FactoryAdapter<VH>,
AdapterHolder.BinderAdapter<A, VH> {
    @NonNull
    protected final Context mContext;
    @NonNull
    protected final Resources mResources;
    private final LayoutInflater mLayoutInflater;
    private DataSetListeners mDataSetListeners;
    private AdapterHolder.Factory<VH> mHolderFactory;
    private AdapterHolder.Binder<A, VH> mHolderBinder;

    public BaseListAdapter(@NonNull Context context) {
        this.mContext = context;
        this.mResources = context.getResources();
        this.mLayoutInflater = LayoutInflater.from((Context)context);
    }

    @Override
    public void registerOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.mDataSetListeners == null) {
            this.mDataSetListeners = new DataSetListeners(this);
        }
        this.mDataSetListeners.registerOnDataSetListener(listener);
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        if (this.mDataSetListeners != null) {
            this.mDataSetListeners.notifyDataSetChanged();
        }
    }

    public void notifyDataSetInvalidated() {
        super.notifyDataSetInvalidated();
        if (this.mDataSetListeners != null) {
            this.mDataSetListeners.notifyDataSetInvalidated();
        }
    }

    @Override
    public void unregisterOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.mDataSetListeners != null) {
            this.mDataSetListeners.unregisterOnDataSetListener(listener);
        }
    }

    @Override
    public void registerOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.mDataSetListeners == null) {
            this.mDataSetListeners = new DataSetListeners(this);
        }
        this.mDataSetListeners.registerOnDataSetActionListener(listener);
    }

    public boolean notifyDataSetActionSelected(int action, int position, @Nullable Object payload) {
        if (position < 0 || position >= this.getItemCount()) {
            return false;
        }
        if (this.onDataSetActionSelected(action, position, payload)) {
            return true;
        }
        return this.mDataSetListeners != null && this.mDataSetListeners.notifyDataSetActionSelected(action, position, payload);
    }

    protected boolean onDataSetActionSelected(int action, int position, @Nullable Object payload) {
        return false;
    }

    @Override
    public void unregisterOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.mDataSetListeners != null) {
            this.mDataSetListeners.unregisterOnDataSetActionListener(listener);
        }
    }

    public final int getCount() {
        return this.getItemCount();
    }

    @Override
    public boolean hasItemAt(int position) {
        return position >= 0 && position < this.getItemCount();
    }

    @Override
    public long getItemId(int position) {
        return this.hasItemAt(position) ? (long)position : -1L;
    }

    @Override
    public void setHolderFactory(@Nullable AdapterHolder.Factory<VH> factory) {
        this.mHolderFactory = factory;
    }

    @Override
    @Nullable
    public AdapterHolder.Factory<VH> getHolderFactory() {
        return this.mHolderFactory;
    }

    @Override
    public void setHolderBinder(@Nullable AdapterHolder.Binder<A, VH> binder) {
        this.mHolderBinder = binder;
    }

    @Override
    @Nullable
    public AdapterHolder.Binder<A, VH> getHolderBinder() {
        return this.mHolderBinder;
    }

    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        ViewHolder viewHolder;
        View view = convertView;
        if (view == null) {
            viewHolder = this.onCreateViewHolder(parent, this.getItemViewType(position));
            view = viewHolder.itemView;
            view.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)view.getTag();
        }
        viewHolder.updateAdapterPosition(position);
        this.onBindViewHolder(viewHolder, position);
        return view;
    }

    @NonNull
    protected VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.mHolderFactory == null) {
            throw AdapterExceptions.noHolderFactoryAttached(this);
        }
        return (VH)((ViewHolder)this.mHolderFactory.createHolder(parent, viewType));
    }

    @NonNull
    public View inflateView(@LayoutRes int resource, @Nullable ViewGroup parent) {
        return this.mLayoutInflater.inflate(resource, parent, false);
    }

    protected void onBindViewHolder(@NonNull VH viewHolder, int position) {
        if (this.mHolderBinder == null) {
            throw AdapterExceptions.noHolderBinderAttached(this);
        }
        this.mHolderBinder.bindHolder(this, viewHolder, position, Collections.EMPTY_LIST);
    }

    @Override
    @NonNull
    @CallSuper
    public Parcelable saveInstanceState() {
        return AdapterSavedState.EMPTY_STATE;
    }

    @Override
    @CallSuper
    public void restoreInstanceState(@NonNull Parcelable savedState) {
    }
}

