/*
 * =================================================================================================
 *                             Copyright (C) 2017 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License 
 * you may obtain at
 * 
 * 		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * You can redistribute, modify or publish any part of the code written within this file but as it 
 * is described in the License, the software distributed under the License is distributed on an 
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.widget.adapter.holder;

import android.support.annotation.NonNull;
import android.view.View;

/**
 * A basic implementation of {@link AdapterHolder} that should be a required type of view holder for
 * all {@code BaseAdapter} implementations.
 *
 * @author Martin Albedinsky
 */
public class ViewHolder implements AdapterHolder {

	/*
	 * Constants ===================================================================================
	 */

	/**
	 * Log TAG.
	 */
	// private static final String TAG = "ViewHolder";

	/*
	 * Interface ===================================================================================
	 */

	/*
	 * Static members ==============================================================================
	 */

	/*
	 * Members =====================================================================================
	 */

	/*
	 * Static members ==============================================================================
	 */

	/*
	 * Members =====================================================================================
	 */

	/**
	 * View with which has been this holder created.
	 */
	public final View itemView;

	/**
	 * Identifies type of the item view associated with this holder.
	 */
	private final int mItemViewType;

	/**
	 * Current position of an item from the associated adapter's data set of which data are presented
	 * in item view of this holder.
	 */
	private int mAdapterPosition = NO_POSITION;

	/*
	 * Constructors ================================================================================
	 */

	/**
	 * Creates a new instance of ViewHolder for the given <var>itemView</var>.
	 *
	 * @param itemView Instance of the view to be associated with new holder.
	 */
	public ViewHolder(@NonNull final View itemView) {
		this(itemView, BASIC_TYPE);
	}

	/**
	 * Creates a new instance of ViewHolder for the given <var>itemView</var> that is of the specified
	 * <var>itemViewType</var>.
	 *
	 * @param itemView Instance of the view to be associated with new holder.
	 */
	public ViewHolder(@NonNull final View itemView, final int itemViewType) {
		this.itemView = itemView;
		this.mItemViewType = itemViewType;
	}

	/*
	 * Methods =====================================================================================
	 */

	/**
	 */
	@Override
	public final int getItemViewType() {
		return mItemViewType;
	}

	/**
	 * Updates the current adapter position of this holder instance.
	 * <p>
	 * <b>Note that this method should be only called by the associated adapter for which context
	 * has been this holder instance created and from the appropriate {@code getView(...)} method.
	 * Calling this method from outside of such context may cause inconsistent results of
	 * {@link #getAdapterPosition()}.</b>
	 *
	 * @param position The new adapter position for this holder.
	 * @see #getAdapterPosition()
	 */
	public final void updateAdapterPosition(final int position) {
		this.mAdapterPosition = position;
	}

	/**
	 */
	@Override
	public final int getAdapterPosition() {
		return mAdapterPosition;
	}

	/*
	 * Inner classes ===============================================================================
	 */
}
