/*
 * =================================================================================================
 *                             Copyright (C) 2017 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License 
 * you may obtain at
 * 
 * 		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * You can redistribute, modify or publish any part of the code written within this file but as it 
 * is described in the License, the software distributed under the License is distributed on an 
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.widget.adapter.holder;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.List;

/**
 * An extension of {@link AdapterHolder} that may be used for adapter holder implementations in
 * association with {@link AdapterHolder.Binder} to simplify data binding logic.
 *
 * @param <A> Type of the adapter of which data may be bound to this holder.
 * @author Martin Albedinsky
 */
public interface AdapterBindingHolder<A> extends AdapterHolder {

	/**
	 * Binds data of the given <var>adapter</var> to this holder for the specified <var>position</var>.
	 *
	 * @param adapter  The adapter of which data to bind to this holder.
	 * @param position The position for which to obtain data from the adapter.
	 * @param payloads Additional list of payloads for the binding. May be an empty list.
	 */
	void bind(@NonNull A adapter, int position, @Nullable List<Object> payloads);
}
