/*
 * =================================================================================================
 *                             Copyright (C) 2017 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.widget.adapter;

import android.support.annotation.Nullable;

/**
 * Listener which receives callbacks about started and finished swap of a specific data in data set.
 *
 * @param <D> Type of data that may be swapped for the adapter.
 */
public interface OnDataSetSwapListener<D> {

	/**
	 * Invoked whenever the given <var>data</var> are about to be changed for the associated data set.
	 *
	 * @param data The new data that is about to be swapped.
	 */
	void onDataSetSwapStarted(@Nullable D data);

	/**
	 * Invoked whenever the given <var>data</var> has been swapped for the associated data set.
	 *
	 * @param data The swapped data.
	 */
	void onDataSetSwapFinished(@Nullable D data);
}
