/*
 * =================================================================================================
 *                             Copyright (C) 2017 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.widget.adapter;

/**
 * A simple interface which may be used for resolving position of an item by its corresponding id.
 *
 * @author Martin Albedinsky
 */
interface ItemPositionResolver {

	/**
	 * Constant that identifies invalid/unspecified position in data set.
	 */
	int NO_POSITION = -1;

	/**
	 * Resolves position of the item which is associated with the specified <var>itemId</var>.
	 *
	 * @param itemId Id of the item of which position to resolve.
	 * @return Position of the item or {@link #NO_POSITION} if position failed to be resolved.
	 */
	int resolveItemPosition(long itemId);
}
