/*
 * =================================================================================================
 *                             Copyright (C) 2017 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.widget.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * Listener which receives callbacks about started and finished swap of adapter's data set.
 *
 * @param <A> Type of the adapter to which will be this data set listener attached.
 * @param <D> Type of data that may be swapped for the adapter.
 */
public interface OnDataSetSwapListener<A, D> {

	/**
	 * Invoked whenever the given <var>dataSet</var> is about to be changed for the specified
	 * <var>adapter</var>.
	 *
	 * @param adapter The adapter of which data set is about to be swapped.
	 * @param dataSet The new data set that is about to be swapped.
	 */
	void onDataSetSwapStarted(@NonNull A adapter, @Nullable D dataSet);

	/**
	 * Invoked whenever the given <var>dataSet</var> has been swapped for the specified <var>adapter</var>.
	 *
	 * @param adapter The adapter of which data set has been swapped.
	 * @param dataSet The swapped data set.
	 */
	void onDataSetSwapFinished(@NonNull A adapter, @Nullable D dataSet);
}
