/*
 * =================================================================================================
 *                             Copyright (C) 2017 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License 
 * you may obtain at
 * 
 * 		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * You can redistribute, modify or publish any part of the code written within this file but as it 
 * is described in the License, the software distributed under the License is distributed on an 
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.widget.adapter;

import android.support.annotation.NonNull;

/**
 * An {@link ItemPositionResolver} implementation that may be used for position resolving of items
 * provided by {@link DataSet}. This resolver implementation simply iterates the attached data set
 * and when the matching item id is found returns the current iterated position.
 *
 * @author Martin Albedinsky
 */
public final class DataSetItemPositionResolver implements ItemPositionResolver {

	/**
	 * Data set used to resolve item's position.
	 */
	private final DataSet mDataSet;

	/**
	 * Creates a new instance of DataSetItemPositionResolver for the given <var>dataSet</var>.
	 *
	 * @param dataSet The desired data set for which to create new resolver.
	 */
	public DataSetItemPositionResolver(@NonNull final DataSet dataSet) {
		this.mDataSet = dataSet;
	}

	/**
	 */
	@Override
	public int resolveItemPosition(long itemId) {
		final int n = mDataSet.getItemCount();
		for (int i = 0; i < n; i++) {
			if (mDataSet.getItemId(i) == itemId) return i;
		}
		return NO_POSITION;
	}
}
