/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter.module;

import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import universum.studios.android.widget.adapter.module.AdapterModule;

public abstract class HeadersModule<H extends Header>
extends AdapterModule {
    private static final String TAG = "HeadersModule";
    private final SparseArray<H> mHeaders = new SparseArray(10);
    private int mHeaderStyleAttr = 16842884;

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.mHeaders.size();
    }

    protected void addHeader(@NonNull H header, int position) {
        this.mHeaders.append(position, header);
    }

    public boolean isHeaderAt(int position) {
        return this.mHeaders.get(position) != null;
    }

    @Nullable
    public H getHeader(int position) {
        return (H)((Header)this.mHeaders.get(position));
    }

    @NonNull
    public SparseArray<H> getHeaders() {
        return this.mHeaders;
    }

    protected void removeHeaderAt(int position) {
        this.mHeaders.remove(position);
    }

    public void clearHeaders() {
        this.mHeaders.clear();
    }

    public int correctPosition(int position) {
        return position - this.getHeadersCountBeforePosition(position);
    }

    public int getHeadersCountBeforePosition(int position) {
        int count = 0;
        for (int i = 0; i < this.mHeaders.size() && this.mHeaders.keyAt(i) < position; ++i) {
            ++count;
        }
        return count;
    }

    public void setHeaderStyleAttr(@AttrRes int styleAttr) {
        this.mHeaderStyleAttr = styleAttr;
    }

    @AttrRes
    public int getHeaderStyleAttr() {
        return this.mHeaderStyleAttr;
    }

    @NonNull
    public View createView(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent, int position) {
        return new TextView(inflater.getContext(), null, this.mHeaderStyleAttr);
    }

    @Nullable
    public Object createViewHolder(@NonNull View view, int position) {
        return null;
    }

    public void bindViewHolder(@NonNull Object viewHolder, int position) {
        if (viewHolder instanceof TextView) {
            H header = this.getHeader(position);
            if (header == null) {
                Log.e((String)TAG, (String)("Invalid header at position(" + position + ")."));
            } else {
                ((TextView)viewHolder).setText(header.getText());
            }
        }
    }

    public static class SimpleHeader
    implements Header {
        private final CharSequence text;

        public SimpleHeader(@NonNull CharSequence text) {
            this.text = text;
        }

        @Override
        @NonNull
        public CharSequence getText() {
            return this.text;
        }
    }

    public static interface Header {
        @NonNull
        public CharSequence getText();
    }
}

