/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter.module;

import android.database.Cursor;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.util.List;
import universum.studios.android.widget.adapter.module.HeadersModule;

public class AlphabeticHeaders
extends HeadersModule<HeadersModule.SimpleHeader> {
    private String mLastProcessedLetter = "";

    public <C extends Cursor & AlphabeticItem> void fromAlphabeticCursor(@NonNull C cursor) {
        this.clearHeaders();
        if (cursor.getCount() > 0 && cursor.moveToFirst()) {
            do {
                this.onProcessAlphabeticItem(cursor, cursor.getPosition());
            } while (cursor.moveToNext());
        }
        this.notifyAdapter();
    }

    public <Item extends AlphabeticItem> void fromAlphabeticList(@NonNull List<Item> list) {
        this.clearHeaders();
        for (int i = 0; i < list.size(); ++i) {
            this.onProcessAlphabeticItem((AlphabeticItem)list.get(i), i);
        }
        this.notifyAdapter();
    }

    @Override
    public void clearHeaders() {
        super.clearHeaders();
        this.mLastProcessedLetter = "";
    }

    protected final void onProcessAlphabeticItem(@NonNull AlphabeticItem item, int position) {
        String name = item.getText().toString();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            String firstLetter = name.substring(0, 1);
            if (!firstLetter.equals(this.mLastProcessedLetter)) {
                this.addHeader(new HeadersModule.SimpleHeader(firstLetter), this.size() + position);
            }
            this.mLastProcessedLetter = firstLetter;
        }
    }

    public static interface AlphabeticItem {
        @NonNull
        public CharSequence getText();
    }
}

