/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter.module;

import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import universum.studios.android.widget.adapter.AdapterSavedState;

public abstract class AdapterModule {
    ModuleAdapter mAdapter;
    private boolean mNotificationEnabled = true;

    public final void attachToAdapter(@NonNull ModuleAdapter adapter) {
        this.mAdapter = adapter;
        this.onAttachedToAdapter(this.mAdapter);
    }

    protected void onAttachedToAdapter(@NonNull ModuleAdapter adapter) {
    }

    protected final void assertAttachedToAdapterOrThrow() {
        if (this.mAdapter == null) {
            throw new IllegalStateException("Not attached to adapter.");
        }
    }

    public void setAdapterNotificationEnabled(boolean enabled) {
        this.mNotificationEnabled = enabled;
    }

    public boolean isAdapterNotificationEnabled() {
        return this.mNotificationEnabled;
    }

    protected final void notifyAdapter() {
        if (this.isAdapterNotificationEnabled() && this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public boolean requiresStateSaving() {
        return false;
    }

    @NonNull
    @CallSuper
    Parcelable saveInstanceState() {
        return AdapterSavedState.EMPTY_STATE;
    }

    @CallSuper
    void restoreInstanceState(@NonNull Parcelable savedState) {
    }

    public static interface ModuleAdapter {
        public void notifyDataSetChanged();

        public int getItemCount();

        public long getItemId(int var1);
    }
}

