/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.List;
import universum.studios.android.widget.adapter.BaseSpinnerAdapter;
import universum.studios.android.widget.adapter.ItemsAdapter;

public abstract class SimpleSpinnerAdapter<I, VH, DVH>
extends BaseSpinnerAdapter<I, VH, DVH>
implements ItemsAdapter<I> {
    public SimpleSpinnerAdapter(@NonNull Context context) {
        super(context);
    }

    public SimpleSpinnerAdapter(@NonNull Context context, @NonNull I[] items) {
        this(context, Arrays.asList(items));
    }

    public SimpleSpinnerAdapter(@NonNull Context context, @NonNull List<I> items) {
        super(context);
        this.mDataSet.attachData(items);
    }

    @Override
    public void changeItems(@Nullable List<I> items) {
        this.swapItems(items);
    }

    @Override
    @Nullable
    public List<I> swapItems(@Nullable List<I> items) {
        List oldData = this.mDataSet.getData();
        if (items == null) {
            this.mDataSet.notifyDataChange(null);
            this.mDataSet.attachData(null);
            if (!this.onItemsChange(null, oldData)) {
                this.notifyDataSetChanged();
            }
        } else {
            this.mDataSet.notifyDataChange(items);
            this.mDataSet.attachData(items);
            if (!this.onItemsChange(items, oldData)) {
                this.notifyDataSetChanged();
            }
        }
        this.mDataSet.notifyDataChanged(items);
        return oldData;
    }

    protected boolean onItemsChange(@Nullable List<I> newItems, @Nullable List<I> oldItems) {
        return false;
    }

    @Override
    @Nullable
    public List<I> getItems() {
        return this.mDataSet.getData();
    }

    @Override
    public int getItemCount() {
        return this.mDataSet.getItemCount();
    }

    @Override
    public boolean hasItemAt(int position) {
        return this.mDataSet.hasItemAt(position);
    }

    @Override
    @NonNull
    public I getItem(int position) {
        return this.mDataSet.getItem(position);
    }
}

