/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import universum.studios.android.widget.adapter.AdapterDataSet;
import universum.studios.android.widget.adapter.AdapterSavedState;
import universum.studios.android.widget.adapter.DataSetAdapter;
import universum.studios.android.widget.adapter.OnDataChangeListener;
import universum.studios.android.widget.adapter.OnDataSetActionListener;
import universum.studios.android.widget.adapter.OnDataSetListener;

public abstract class BaseRecyclerAdapter<I, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH>
implements DataSetAdapter<I> {
    protected final Context mContext;
    protected final LayoutInflater mLayoutInflater;
    protected final Resources mResources;
    final AdapterDataSet<BaseRecyclerAdapter<I, VH>, I> mDataSet;
    private RecyclerView.AdapterDataObserver mDataObserver;

    public BaseRecyclerAdapter(@NonNull Context context) {
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.mResources = context.getResources();
        this.mDataSet = new AdapterDataSet(this);
    }

    @Override
    public void registerOnDataChangeListener(@NonNull OnDataChangeListener listener) {
        this.mDataSet.registerOnDataChangeListener(listener);
    }

    @Override
    public void unregisterOnDataChangeListener(@NonNull OnDataChangeListener listener) {
        this.mDataSet.unregisterOnDataChangeListener(listener);
    }

    @Override
    public void registerOnDataSetListener(@NonNull OnDataSetListener listener) {
        this.mDataSet.registerOnDataSetListener(listener);
        if (this.mDataObserver == null) {
            this.mDataObserver = new RecyclerView.AdapterDataObserver(){

                public void onChanged() {
                    BaseRecyclerAdapter.this.mDataSet.notifyDataSetChanged();
                }

                public void onItemRangeInserted(int positionStart, int itemCount) {
                    BaseRecyclerAdapter.this.mDataSet.notifyDataSetChanged();
                }

                public void onItemRangeRemoved(int positionStart, int itemCount) {
                    BaseRecyclerAdapter.this.mDataSet.notifyDataSetChanged();
                }

                public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
                    BaseRecyclerAdapter.this.mDataSet.notifyDataSetChanged();
                }
            };
            this.registerAdapterDataObserver(this.mDataObserver);
        }
    }

    @Override
    public void unregisterOnDataSetListener(@NonNull OnDataSetListener listener) {
        this.mDataSet.unregisterOnDataSetListener(listener);
        if (this.mDataObserver != null) {
            this.unregisterAdapterDataObserver(this.mDataObserver);
        }
    }

    @Override
    public void registerOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        this.mDataSet.registerOnDataSetActionListener(listener);
    }

    protected boolean notifyDataSetActionSelected(int action, int position, @Nullable Object payload) {
        return position >= 0 && position < this.getItemCount() && (this.onDataSetActionSelected(action, position, payload) || this.mDataSet.notifyDataSetActionSelected(action, position, payload));
    }

    protected boolean onDataSetActionSelected(int action, int position, @Nullable Object payload) {
        return false;
    }

    @Override
    public void unregisterOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        this.mDataSet.unregisterOnDataSetActionListener(listener);
    }

    @Override
    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    @Override
    public boolean hasItemAt(int position) {
        return position >= 0 && position < this.getItemCount();
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public boolean isEnabled(int position) {
        return true;
    }

    public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

    @NonNull
    protected View inflate(@LayoutRes int resource, @NonNull ViewGroup parent) {
        return this.mLayoutInflater.inflate(resource, parent, false);
    }

    public abstract void onBindViewHolder(@NonNull VH var1, int var2);

    @Override
    @NonNull
    @CallSuper
    public Parcelable saveInstanceState() {
        return AdapterSavedState.EMPTY_STATE;
    }

    @Override
    @CallSuper
    public void restoreInstanceState(@NonNull Parcelable savedState) {
    }

    public static class SimpleViewHolder
    extends RecyclerView.ViewHolder {
        public SimpleViewHolder(@NonNull View itemView) {
            super(itemView);
        }
    }
}

