/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import universum.studios.android.widget.adapter.AdapterDataSet;
import universum.studios.android.widget.adapter.AdapterSavedState;
import universum.studios.android.widget.adapter.DataSetAdapter;
import universum.studios.android.widget.adapter.OnDataChangeListener;
import universum.studios.android.widget.adapter.OnDataSetActionListener;
import universum.studios.android.widget.adapter.OnDataSetListener;
import universum.studios.android.widget.adapter.ViewHolder;

public abstract class BaseAdapter<I, VH>
extends android.widget.BaseAdapter
implements DataSetAdapter<I> {
    protected final Context mContext;
    protected final LayoutInflater mLayoutInflater;
    protected final Resources mResources;
    final AdapterDataSet<BaseAdapter<I, VH>, I> mDataSet;
    int mCurrentViewType;

    public BaseAdapter(@NonNull Context context) {
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.mResources = context.getResources();
        this.mDataSet = new AdapterDataSet(this);
    }

    @Override
    public void registerOnDataChangeListener(@NonNull OnDataChangeListener listener) {
        this.mDataSet.registerOnDataChangeListener(listener);
    }

    @Override
    public void unregisterOnDataChangeListener(@NonNull OnDataChangeListener listener) {
        this.mDataSet.unregisterOnDataChangeListener(listener);
    }

    @Override
    public void registerOnDataSetListener(@NonNull OnDataSetListener listener) {
        this.mDataSet.registerOnDataSetListener(listener);
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.mDataSet.notifyDataSetChanged();
    }

    public void notifyDataSetInvalidated() {
        super.notifyDataSetInvalidated();
        this.mDataSet.notifyDataSetInvalidated();
    }

    @Override
    public void unregisterOnDataSetListener(@NonNull OnDataSetListener listener) {
        this.mDataSet.unregisterOnDataSetListener(listener);
    }

    @Override
    public void registerOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        this.mDataSet.registerOnDataSetActionListener(listener);
    }

    protected boolean notifyDataSetActionSelected(int action, int position, @Nullable Object payload) {
        return position >= 0 && position < this.getItemCount() && (this.onDataSetActionSelected(action, position, payload) || this.mDataSet.notifyDataSetActionSelected(action, position, payload));
    }

    protected boolean onDataSetActionSelected(int action, int position, @Nullable Object payload) {
        return false;
    }

    @Override
    public void unregisterOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        this.mDataSet.unregisterOnDataSetActionListener(listener);
    }

    public final int getCount() {
        return this.getItemCount();
    }

    @Override
    public boolean hasItemAt(int position) {
        return position >= 0 && position < this.getItemCount();
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public boolean hasStableIds() {
        return false;
    }

    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        Object viewHolder;
        View view = convertView;
        this.mCurrentViewType = this.getItemViewType(position);
        if (view == null) {
            view = this.onCreateView(parent, position);
            VH holder = this.onCreateViewHolder(view, position);
            if (holder == null) {
                viewHolder = view;
            } else {
                viewHolder = holder;
                view.setTag(viewHolder);
            }
        } else {
            Object holder = view.getTag();
            viewHolder = holder == null ? view : holder;
        }
        this.ensureViewHolderPosition(viewHolder, position);
        this.onBindViewHolder(viewHolder, position);
        return view;
    }

    protected final int currentViewType() {
        return this.mCurrentViewType;
    }

    @NonNull
    protected abstract View onCreateView(@NonNull ViewGroup var1, int var2);

    @NonNull
    protected View inflate(@LayoutRes int resource, @NonNull ViewGroup parent) {
        return this.mLayoutInflater.inflate(resource, parent, false);
    }

    @Nullable
    protected VH onCreateViewHolder(@NonNull View itemView, int position) {
        return null;
    }

    final void ensureViewHolderPosition(Object viewHolder, int position) {
        if (viewHolder instanceof ViewHolder) {
            ((ViewHolder)viewHolder).updateAdapterPosition(position);
        }
    }

    protected abstract void onBindViewHolder(@NonNull VH var1, int var2);

    @Override
    @NonNull
    @CallSuper
    public Parcelable saveInstanceState() {
        return AdapterSavedState.EMPTY_STATE;
    }

    @Override
    @CallSuper
    public void restoreInstanceState(@NonNull Parcelable savedState) {
    }
}

