/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.support.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import universum.studios.android.widget.adapter.DataSet;
import universum.studios.android.widget.adapter.DataSetAdapter;
import universum.studios.android.widget.adapter.OnDataChangeListener;
import universum.studios.android.widget.adapter.OnDataSetActionListener;
import universum.studios.android.widget.adapter.OnDataSetListener;

final class AdapterDataSet<A extends DataSetAdapter<I>, I>
implements DataSet<I> {
    static final int LISTENER_DATA_CHANGE = 1;
    static final int LISTENER_DATA_SET = 2;
    static final int LISTENER_DATA_SET_ACTION = 4;
    private static final int LISTENER_ALL = 7;
    static final int CALLBACK_DATA_CHANGE = 1;
    static final int CALLBACK_DATA_CHANGED = 2;
    static final int CALLBACK_DATA_SET_CHANGED = 4;
    static final int CALLBACK_DATA_SET_INVALIDATED = 8;
    static final int CALLBACK_DATA_SET_ACTION_SELECTED = 16;
    private static final int CALLBACK_ALL = 31;
    private final A mAdapter;
    private List<OnDataChangeListener> mDataChangeListeners;
    private List<OnDataSetListener> mDataSetListeners;
    private List<OnDataSetActionListener> mDataSetActionListeners;
    private List<I> mData;
    private int mEnabledListeners = 7;
    private int mEnabledListenerCallbacks = 31;

    AdapterDataSet(A adapter) {
        this.mAdapter = adapter;
    }

    void setListenersEnabled(int listeners, boolean enabled) {
        this.mEnabledListeners = enabled ? (this.mEnabledListeners |= listeners) : (this.mEnabledListeners &= ~listeners);
    }

    void setListenerCallbacksEnabled(int listenerCallback, boolean enabled) {
        this.mEnabledListenerCallbacks = enabled ? (this.mEnabledListenerCallbacks |= listenerCallback) : (this.mEnabledListenerCallbacks &= ~listenerCallback);
    }

    @Override
    public void registerOnDataChangeListener(@NonNull OnDataChangeListener listener) {
        if (this.mDataChangeListeners == null) {
            this.mDataChangeListeners = new ArrayList<OnDataChangeListener>(1);
        }
        if (!this.mDataChangeListeners.contains(listener)) {
            this.mDataChangeListeners.add(listener);
        }
    }

    void notifyDataChange(Object data) {
        if ((this.mEnabledListeners & 1) == 0 || (this.mEnabledListenerCallbacks & 1) == 0) {
            return;
        }
        if (this.mDataChangeListeners != null && !this.mDataChangeListeners.isEmpty()) {
            for (OnDataChangeListener listener : this.mDataChangeListeners) {
                listener.onDataChange(this.mAdapter, data);
            }
        }
    }

    void notifyDataChanged(Object data) {
        if ((this.mEnabledListeners & 1) == 0 || (this.mEnabledListenerCallbacks & 2) == 0) {
            return;
        }
        if (this.mDataChangeListeners != null && !this.mDataChangeListeners.isEmpty()) {
            for (OnDataChangeListener listener : this.mDataChangeListeners) {
                listener.onDataChanged(this.mAdapter, data);
            }
        }
    }

    @Override
    public void unregisterOnDataChangeListener(@NonNull OnDataChangeListener listener) {
        if (this.mDataChangeListeners != null) {
            this.mDataChangeListeners.remove(listener);
        }
    }

    @Override
    public void registerOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.mDataSetListeners == null) {
            this.mDataSetListeners = new ArrayList<OnDataSetListener>(1);
        }
        if (!this.mDataSetListeners.contains(listener)) {
            this.mDataSetListeners.add(listener);
        }
    }

    void notifyDataSetChanged() {
        if ((this.mEnabledListeners & 2) == 0 || (this.mEnabledListenerCallbacks & 4) == 0) {
            return;
        }
        if (this.mDataSetListeners != null && !this.mDataSetListeners.isEmpty()) {
            for (OnDataSetListener listener : this.mDataSetListeners) {
                listener.onDataSetChanged(this.mAdapter);
            }
        }
    }

    void notifyDataSetInvalidated() {
        if ((this.mEnabledListeners & 2) == 0 || (this.mEnabledListenerCallbacks & 8) == 0) {
            return;
        }
        if (this.mDataSetListeners != null && !this.mDataSetListeners.isEmpty()) {
            for (OnDataSetListener listener : this.mDataSetListeners) {
                listener.onDataSetInvalidated(this.mAdapter);
            }
        }
    }

    @Override
    public void unregisterOnDataSetListener(@NonNull OnDataSetListener listener) {
        if (this.mDataSetListeners != null) {
            this.mDataSetListeners.remove(listener);
        }
    }

    @Override
    public void registerOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.mDataSetActionListeners == null) {
            this.mDataSetActionListeners = new ArrayList<OnDataSetActionListener>(1);
        }
        if (!this.mDataSetActionListeners.contains(listener)) {
            this.mDataSetActionListeners.add(listener);
        }
    }

    boolean notifyDataSetActionSelected(int action, int position, Object payload) {
        if ((this.mEnabledListeners & 4) == 0 || (this.mEnabledListenerCallbacks & 0x10) == 0) {
            return false;
        }
        if (this.mDataSetActionListeners != null && !this.mDataSetActionListeners.isEmpty()) {
            for (OnDataSetActionListener listener : this.mDataSetActionListeners) {
                if (!listener.onDataSetActionSelected(this.mAdapter, action, position, this.getItemId(position), payload)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void unregisterOnDataSetActionListener(@NonNull OnDataSetActionListener listener) {
        if (this.mDataSetActionListeners != null) {
            this.mDataSetActionListeners.remove(listener);
        }
    }

    List<I> attachData(List<I> data) {
        List<I> oldData = this.mData;
        this.mData = data;
        return oldData;
    }

    List<I> getData() {
        return this.mData;
    }

    @Override
    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    @Override
    public int getItemCount() {
        return this.mData == null ? 0 : this.mData.size();
    }

    @Override
    public boolean hasItemAt(int position) {
        return position >= 0 && position < this.getItemCount();
    }

    @Override
    @NonNull
    public I getItem(int position) {
        if (!this.hasItemAt(position)) {
            throw new IndexOutOfBoundsException("Requested item at invalid position(" + position + "). " + "Data set has items in count of(" + this.getItemCount() + ").");
        }
        return this.mData.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ListenerCallback {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Listener {
    }
}

