/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.widget.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.List;
import universum.studios.android.widget.adapter.BaseAdapter;
import universum.studios.android.widget.adapter.ItemsAdapter;

public abstract class SimpleAdapter<Item, VH>
extends BaseAdapter<Item, VH>
implements ItemsAdapter<Item> {
    public SimpleAdapter(@NonNull Context context) {
        super(context);
    }

    public SimpleAdapter(@NonNull Context context, @NonNull Item[] items) {
        this(context, Arrays.asList(items));
    }

    public SimpleAdapter(@NonNull Context context, @NonNull List<Item> items) {
        super(context);
        this.mDataSet.attachData(items);
    }

    @Override
    public void changeItems(@Nullable List<Item> items) {
        this.swapItems(items);
    }

    @Override
    @Nullable
    public List<Item> swapItems(@Nullable List<Item> items) {
        List oldData = this.mDataSet.getData();
        if (items != null) {
            this.mDataSet.notifyDataChange(items);
            this.mDataSet.attachData(items);
            if (!this.onItemsChange(items, oldData)) {
                this.notifyDataSetChanged();
            }
        } else {
            this.mDataSet.notifyDataChange(null);
            this.mDataSet.attachData(null);
            if (!this.onItemsChange(null, oldData)) {
                this.notifyDataSetChanged();
            }
        }
        this.mDataSet.notifyDataChanged(items);
        return oldData;
    }

    protected boolean onItemsChange(@Nullable List<Item> newItems, @Nullable List<Item> oldItems) {
        return false;
    }

    @Override
    @Nullable
    public List<Item> getItems() {
        return this.mDataSet.getData();
    }

    @Override
    public int getItemCount() {
        return this.mDataSet.getItemCount();
    }

    @Override
    public boolean hasItemAt(int position) {
        return this.mDataSet.hasItemAt(position);
    }

    @Override
    @NonNull
    public Item getItem(int position) {
        return this.mDataSet.getItem(position);
    }
}

