/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.version;

import androidx.annotation.NonNull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import universum.studios.android.version.Version;
import universum.studios.android.version.VersionRepository;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\f2\b\b\u0001\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u000f\u001a\u00020\f2\b\b\u0001\u0010\u000e\u001a\u00020\u0005J\u001a\u0010\u0010\u001a\u00020\f2\b\b\u0001\u0010\u0011\u001a\u00020\u00052\b\b\u0001\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u0013\u001a\u00020\f2\b\b\u0001\u0010\u000e\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0014"}, d2={"Luniversum/studios/android/version/VersionManager;", "", "repository", "Luniversum/studios/android/version/VersionRepository;", "actualVersion", "Luniversum/studios/android/version/Version;", "(Luniversum/studios/android/version/VersionRepository;Luniversum/studios/android/version/Version;)V", "getActualVersion", "()Luniversum/studios/android/version/Version;", "previousVersion", "getPreviousVersion", "checkUpdated", "", "checkUpdatedFrom", "version", "checkUpdatedFromBelow", "checkUpdatedFromTo", "from", "to", "checkUpdatedTo", "library_release"})
public final class VersionManager {
    @NonNull
    @NotNull
    private final Version previousVersion;
    @NotNull
    private final Version actualVersion;

    @NotNull
    public final Version getPreviousVersion() {
        return this.previousVersion;
    }

    public final boolean checkUpdatedFrom(@NonNull @NotNull Version version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return this.checkUpdated() && Intrinsics.areEqual((Object)version, (Object)this.previousVersion);
    }

    public final boolean checkUpdatedFromBelow(@NonNull @NotNull Version version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return this.checkUpdated() && this.previousVersion.isLessThan(version);
    }

    public final boolean checkUpdatedTo(@NonNull @NotNull Version version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return this.checkUpdated() && Intrinsics.areEqual((Object)version, (Object)this.actualVersion);
    }

    public final boolean checkUpdatedFromTo(@NonNull @NotNull Version from, @NonNull @NotNull Version to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        return this.checkUpdated() && Intrinsics.areEqual((Object)from, (Object)this.previousVersion) && Intrinsics.areEqual((Object)to, (Object)this.actualVersion);
    }

    public final boolean checkUpdated() {
        return !Version.Companion.isEmpty(this.previousVersion) && Intrinsics.areEqual((Object)this.actualVersion, (Object)this.previousVersion) ^ true;
    }

    @NotNull
    public final Version getActualVersion() {
        return this.actualVersion;
    }

    public VersionManager(@NonNull @NotNull VersionRepository repository, @NonNull @NotNull Version actualVersion) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)actualVersion, (String)"actualVersion");
        this.actualVersion = actualVersion;
        Version persistedActualVersion = repository.getActualVersion();
        if (Version.Companion.isEmpty(persistedActualVersion)) {
            this.previousVersion = Version.Companion.getEMPTY();
            repository.persistActualVersion(this.actualVersion);
        } else if (Intrinsics.areEqual((Object)this.actualVersion, (Object)persistedActualVersion)) {
            this.previousVersion = repository.getPreviousVersion();
        } else {
            this.previousVersion = persistedActualVersion;
            repository.persistPreviousVersion(persistedActualVersion);
            repository.persistActualVersion(this.actualVersion);
        }
    }
}

