/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.version;

import androidx.annotation.NonNull;
import java.util.Arrays;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B\u0011\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u0000J\u0010\u0010\u0010\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u0000J\u0010\u0010\u0011\u001a\u00020\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\u0000J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Luniversum/studios/android/version/Version;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "compareTo", "", "other", "equals", "", "", "hashCode", "isGreaterThan", "version", "isLessThan", "isSame", "toString", "Companion", "library_release"})
public final class Version
implements Comparable<Version> {
    @NotNull
    private final String name;
    @NonNull
    @NotNull
    private static final Version EMPTY;
    private static final String SEMANTIC_SEPARATOR = ".";
    private static final Pattern SEMANTIC_SEPARATION_PATTERN;
    private static final int SEMANTIC_PART_MAX_LENGTH = 4;
    public static final Companion Companion;

    public final boolean isSame(@NonNull @NotNull Version version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return this.compareTo(version) == 0;
    }

    public final boolean isGreaterThan(@NonNull @NotNull Version version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return this.compareTo(version) > 0;
    }

    public final boolean isLessThan(@NonNull @NotNull Version version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return this.compareTo(version) < 0;
    }

    @Override
    public int compareTo(@NonNull @NotNull Version other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Companion.compare(this.name, other.name);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version version = (Version)other;
        return Intrinsics.areEqual((Object)version.name, (Object)this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @NotNull
    public String toString() {
        return Intrinsics.areEqual((Object)this, (Object)EMPTY) ? "Version.EMPTY" : "Version{name: " + this.name + '}';
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    private Version(@NonNull String name) {
        this.name = name;
    }

    static {
        Companion = new Companion(null);
        EMPTY = new Version("");
        SEMANTIC_SEPARATION_PATTERN = Pattern.compile(SEMANTIC_SEPARATOR, 16);
    }

    public /* synthetic */ Version(@NonNull @NotNull String name, DefaultConstructorMarker $constructor_marker) {
        this(name);
    }

    @NotNull
    public static final Version getEMPTY() {
        Companion companion = Companion;
        return EMPTY;
    }

    @JvmStatic
    @NotNull
    public static final Version create(@NonNull @NotNull String name) {
        return Companion.create(name);
    }

    @JvmStatic
    public static final boolean isEmpty(@NonNull @NotNull Version version) {
        return Companion.isEmpty(version);
    }

    @JvmStatic
    public static final int compare(@NonNull @NotNull String firstName, @NonNull @NotNull String secondName) {
        return Companion.compare(firstName, secondName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000f\u001a\u00020\t2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\u000eH\u0007J\u0012\u0010\u0012\u001a\u00020\u00042\b\b\u0001\u0010\u0013\u001a\u00020\u000eH\u0007J\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Luniversum/studios/android/version/Version$Companion;", "", "()V", "EMPTY", "Luniversum/studios/android/version/Version;", "EMPTY$annotations", "getEMPTY", "()Luniversum/studios/android/version/Version;", "SEMANTIC_PART_MAX_LENGTH", "", "SEMANTIC_SEPARATION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SEMANTIC_SEPARATOR", "", "compare", "firstName", "secondName", "create", "name", "isEmpty", "", "version", "normalize", "semanticPartMaxLength", "library_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void EMPTY$annotations() {
        }

        @NotNull
        public final Version getEMPTY() {
            return EMPTY;
        }

        @JvmStatic
        @NotNull
        public final Version create(@NonNull @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            CharSequence charSequence = name;
            if (charSequence.length() == 0) {
                throw (Throwable)new IllegalArgumentException("Version cannot have empty name!");
            }
            return new Version(name, null);
        }

        @JvmStatic
        public final boolean isEmpty(@NonNull @NotNull Version version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return Intrinsics.areEqual((Object)version, (Object)this.getEMPTY());
        }

        @JvmStatic
        public final int compare(@NonNull @NotNull String firstName, @NonNull @NotNull String secondName) {
            Intrinsics.checkParameterIsNotNull((Object)firstName, (String)"firstName");
            Intrinsics.checkParameterIsNotNull((Object)secondName, (String)"secondName");
            String firstNormalized = this.normalize(firstName);
            String secondNormalized = this.normalize(secondName);
            return firstNormalized.compareTo(secondNormalized);
        }

        private final String normalize(String name) {
            CharSequence charSequence = name;
            return charSequence.length() > 0 ? this.normalize(name, 4) : "";
        }

        private final String normalize(String name, int semanticPartMaxLength) {
            String[] versionParts = SEMANTIC_SEPARATION_PATTERN.split(name);
            StringBuilder builder = new StringBuilder(name.length());
            for (String part : versionParts) {
                String string;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "" + '%' + semanticPartMaxLength + 's';
                Object[] objectArray = new Object[]{part};
                StringBuilder stringBuilder = builder;
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                stringBuilder.append(string);
            }
            String string = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

