/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.util;

import android.content.Context;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class Toaster {
    private Toaster() {
        throw new UnsupportedOperationException();
    }

    public static void showToast(@NonNull Context context, @StringRes int resId) {
        Toaster.showToast(context, 0, resId);
    }

    public static void showToast(@NonNull Context context, int duration, @StringRes int resId) {
        Toaster.showToast(context, context.getResources().getText(resId), duration);
    }

    public static void showToast(@NonNull Context context, int duration, @StringRes int resId, Object ... args) {
        Toaster.showToast(context, context.getResources().getString(resId, args), duration);
    }

    public static void showToast(@NonNull Context context, int duration, @NonNull String text, Object ... args) {
        Toaster.showToast(context, String.format(text, args), duration);
    }

    public static void showToast(@NonNull Context context, @NonNull CharSequence text) {
        Toaster.showToast(context, text, 0);
    }

    public static void showToast(@NonNull Context context, @NonNull CharSequence text, int duration) {
        Toaster.showToastInner(context, text, duration);
    }

    private static void showToastInner(Context context, CharSequence text, int duration) {
        switch (duration) {
            case 1: {
                Toast.makeText((Context)context, (CharSequence)text, (int)1).show();
                break;
            }
            default: {
                Toast.makeText((Context)context, (CharSequence)text, (int)0).show();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Duration {
    }
}

