/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.util;

import android.content.Context;
import android.os.Process;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;

public final class Permissions {
    private Permissions() {
        throw new UnsupportedOperationException();
    }

    @CheckResult
    public static boolean hasAnyOf(@NonNull Context context, String ... permissions) {
        for (String permission : permissions) {
            if (!Permissions.has(context, permission)) continue;
            return true;
        }
        return false;
    }

    @CheckResult
    public static boolean hasAllOf(@NonNull Context context, String ... permissions) {
        for (String permission : permissions) {
            if (Permissions.has(context, permission)) continue;
            return false;
        }
        return true;
    }

    @CheckResult
    public static boolean has(@NonNull Context context, @NonNull String permission) {
        return context.checkPermission(permission, Process.myPid(), Process.myUid()) == 0;
    }

    @CheckResult
    public static boolean isSingleGranted(@NonNull int[] grantResults) {
        return grantResults.length == 1 && grantResults[0] == 0;
    }
}

