/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.util;

import android.content.res.Configuration;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import java.util.Locale;

public class Localer {
    private Locale locale;

    public Localer() {
        this(Locale.ENGLISH);
    }

    public Localer(@NonNull Locale locale) {
        this.locale = locale;
    }

    public void dispatchApplicationCreated(@NonNull Resources resources) {
        this.updateLocale(resources.getConfiguration(), resources);
    }

    public void dispatchConfigurationChanged(@NonNull Configuration newConfig, @NonNull Resources resources) {
        this.updateLocale(new Configuration(newConfig), resources);
    }

    public void setLocale(@NonNull Locale locale, @NonNull Resources resources) {
        this.locale = locale;
        this.updateLocale(resources.getConfiguration(), resources);
    }

    @NonNull
    public Locale getLocale() {
        return this.locale;
    }

    private void updateLocale(Configuration config, Resources resources) {
        Locale.setDefault(this.locale);
        config.locale = this.locale;
        resources.updateConfiguration(config, resources.getDisplayMetrics());
    }
}

