/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.util;

import android.content.Context;
import android.os.Process;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;

public abstract class Permissions {
    protected Permissions() {
    }

    @CheckResult
    public static boolean hasAnyOf(@NonNull Context context, String ... permissions) {
        for (String permission : permissions) {
            if (!Permissions.has(context, permission)) continue;
            return true;
        }
        return false;
    }

    @CheckResult
    public static boolean hasAllOf(@NonNull Context context, String ... permissions) {
        for (String permission : permissions) {
            if (Permissions.has(context, permission)) continue;
            return false;
        }
        return true;
    }

    @CheckResult
    public static boolean has(@NonNull Context context, @NonNull String permission) {
        return context.checkPermission(permission, Process.myPid(), Process.myUid()) == 0;
    }
}

