/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.util;

import android.annotation.SuppressLint;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import universum.studios.android.util.Logger;

public class SimpleLogger
implements Logger {
    private static final boolean WTF_SUPPORTED = Build.VERSION.SDK_INT >= 8;
    private int mLogLevel;

    public SimpleLogger(int level) {
        this.mLogLevel = level;
    }

    @Override
    public void setLogLevel(int level) {
        this.mLogLevel = level;
    }

    @Override
    public int getLogLevel() {
        return this.mLogLevel;
    }

    @Override
    public boolean isLoggable(@NonNull String tag, int level) {
        return this.mLogLevel <= level;
    }

    @Override
    public void d(@NonNull String tag, @NonNull String msg) {
        if (this.isLoggable(tag, 3)) {
            Log.d((String)tag, (String)msg);
        }
    }

    @Override
    public void d(@NonNull String tag, @NonNull String msg, @Nullable Throwable tr) {
        if (this.isLoggable(tag, 3)) {
            Log.d((String)tag, (String)msg, (Throwable)tr);
        }
    }

    @Override
    public void v(@NonNull String tag, @NonNull String msg) {
        if (this.isLoggable(tag, 2)) {
            Log.v((String)tag, (String)msg);
        }
    }

    @Override
    public void v(@NonNull String tag, @NonNull String msg, @Nullable Throwable tr) {
        if (this.isLoggable(tag, 2)) {
            Log.v((String)tag, (String)msg, (Throwable)tr);
        }
    }

    @Override
    public void i(@NonNull String tag, @NonNull String msg) {
        if (this.isLoggable(tag, 4)) {
            Log.i((String)tag, (String)msg);
        }
    }

    @Override
    public void i(@NonNull String tag, @NonNull String msg, @Nullable Throwable tr) {
        if (this.isLoggable(tag, 4)) {
            Log.i((String)tag, (String)msg, (Throwable)tr);
        }
    }

    @Override
    public void w(@NonNull String tag, @NonNull String msg) {
        if (this.isLoggable(tag, 5)) {
            Log.w((String)tag, (String)msg);
        }
    }

    @Override
    public void w(@NonNull String tag, @Nullable Throwable tr) {
        if (this.isLoggable(tag, 5)) {
            Log.w((String)tag, (Throwable)tr);
        }
    }

    @Override
    public void w(@NonNull String tag, @NonNull String msg, @Nullable Throwable tr) {
        if (this.isLoggable(tag, 5)) {
            Log.w((String)tag, (String)msg, (Throwable)tr);
        }
    }

    @Override
    public void e(@NonNull String tag, @NonNull String msg) {
        if (this.isLoggable(tag, 6)) {
            Log.e((String)tag, (String)msg);
        }
    }

    @Override
    public void e(@NonNull String tag, @NonNull String msg, @Nullable Throwable tr) {
        if (this.isLoggable(tag, 6)) {
            Log.e((String)tag, (String)msg, (Throwable)tr);
        }
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void wtf(@NonNull String tag, @NonNull String msg) {
        if (WTF_SUPPORTED) {
            Log.wtf((String)tag, (String)msg);
        }
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void wtf(@NonNull String tag, @Nullable Throwable tr) {
        if (WTF_SUPPORTED) {
            Log.wtf((String)tag, (Throwable)tr);
        }
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void wtf(@NonNull String tag, @NonNull String msg, @Nullable Throwable tr) {
        if (WTF_SUPPORTED) {
            Log.wtf((String)tag, (String)msg, (Throwable)tr);
        }
    }

    @Override
    public void log(int level, @NonNull String tag, @NonNull String msg) {
        if (this.isLoggable(tag, level)) {
            this.forceLog(level, tag, msg);
        }
    }

    @Override
    public void forceLog(int level, @NonNull String tag, @NonNull String msg) {
        Log.println((int)level, (String)tag, (String)msg);
    }

    @Override
    @Nullable
    public String getStackTraceString(@Nullable Throwable tr) {
        return Log.getStackTraceString((Throwable)tr);
    }
}

