/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.util;

import android.content.res.Configuration;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import java.util.Locale;

public class Localer {
    private Locale mLocale;

    public Localer() {
        this(Locale.ENGLISH);
    }

    public Localer(@NonNull Locale locale) {
        this.mLocale = locale;
    }

    public void dispatchApplicationCreated(@NonNull Resources resources) {
        this.updateLocale(resources.getConfiguration(), resources);
    }

    public void dispatchConfigurationChanged(@NonNull Configuration newConfig, @NonNull Resources resources) {
        this.updateLocale(new Configuration(newConfig), resources);
    }

    public void setLocale(@NonNull Locale locale, @NonNull Resources resources) {
        this.mLocale = locale;
        this.updateLocale(resources.getConfiguration(), resources);
    }

    @NonNull
    public Locale getLocale() {
        return this.mLocale;
    }

    private void updateLocale(Configuration config, Resources resources) {
        Locale.setDefault(this.mLocale);
        config.locale = this.mLocale;
        resources.updateConfiguration(config, resources.getDisplayMetrics());
    }
}

