/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.util;

import android.annotation.SuppressLint;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Logger {
    private static final int NONE = 0;
    public static final int VERBOSE = 1;
    public static final int DEBUG = 2;
    public static final int INFO = 4;
    public static final int WARN = 8;
    public static final int ERROR = 16;
    public static final int WTF = 32;
    private static final int ALL = 63;
    private static final int DEBUG_MODE = 31;
    private static final int RELEASE_MODE = 28;
    private static final boolean WTF_SUPPORTED = Build.VERSION.SDK_INT >= 8;
    public static int sEnabledLogs;

    private Logger() {
    }

    public static void reset() {
        sEnabledLogs = 30;
    }

    public static void enable(int logFlag) {
        sEnabledLogs |= logFlag;
    }

    public static void disable(int logFlag) {
        sEnabledLogs &= ~logFlag;
    }

    public static void enableAll() {
        sEnabledLogs = 63;
    }

    public static void disableAll() {
        sEnabledLogs = 0;
    }

    public static boolean isEnabled(int logFlag) {
        return (sEnabledLogs & logFlag) != 0;
    }

    public static void switchToDebugMode() {
        sEnabledLogs = 31;
    }

    public static void switchToReleaseMode() {
        sEnabledLogs = 28;
    }

    public static void d(@NonNull String tag, @NonNull String msg) {
        if ((sEnabledLogs & 2) != 0) {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void d(@NonNull String tag, @NonNull String msg, @Nullable Throwable tr) {
        if ((sEnabledLogs & 2) != 0) {
            Log.d((String)tag, (String)msg, (Throwable)tr);
        }
    }

    public static void v(@NonNull String tag, @NonNull String msg) {
        if ((sEnabledLogs & 1) != 0) {
            Log.v((String)tag, (String)msg);
        }
    }

    public static void v(@NonNull String tag, @NonNull String msg, @Nullable Throwable tr) {
        if ((sEnabledLogs & 1) != 0) {
            Log.v((String)tag, (String)msg, (Throwable)tr);
        }
    }

    public static void i(@NonNull String tag, @NonNull String msg) {
        if ((sEnabledLogs & 4) != 0) {
            Log.i((String)tag, (String)msg);
        }
    }

    public static void i(@NonNull String tag, @NonNull String msg, @Nullable Throwable tr) {
        if ((sEnabledLogs & 4) != 0) {
            Log.i((String)tag, (String)msg, (Throwable)tr);
        }
    }

    public static void w(@NonNull String tag, @NonNull String msg) {
        if ((sEnabledLogs & 8) != 0) {
            Log.w((String)tag, (String)msg);
        }
    }

    public static void w(@NonNull String tag, @Nullable Throwable tr) {
        if ((sEnabledLogs & 8) != 0) {
            Log.w((String)tag, (Throwable)tr);
        }
    }

    public static void w(@NonNull String tag, @NonNull String msg, @Nullable Throwable tr) {
        if ((sEnabledLogs & 8) != 0) {
            Log.w((String)tag, (String)msg, (Throwable)tr);
        }
    }

    public static void e(@NonNull String tag, @NonNull String msg) {
        if ((sEnabledLogs & 0x10) != 0) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void e(@NonNull String tag, @NonNull String msg, @Nullable Throwable tr) {
        if ((sEnabledLogs & 0x10) != 0) {
            Log.e((String)tag, (String)msg, (Throwable)tr);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void wtf(@NonNull String tag, @NonNull String msg) {
        if ((sEnabledLogs & 0x20) != 0 && WTF_SUPPORTED) {
            Log.wtf((String)tag, (String)msg);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void wtf(@NonNull String tag, @Nullable Throwable tr) {
        if ((sEnabledLogs & 0x20) != 0 && WTF_SUPPORTED) {
            Log.wtf((String)tag, (Throwable)tr);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void wtf(@NonNull String tag, @NonNull String msg, @Nullable Throwable tr) {
        if ((sEnabledLogs & 0x20) != 0 && WTF_SUPPORTED) {
            Log.wtf((String)tag, (String)msg, (Throwable)tr);
        }
    }

    public static boolean isLoggable(@NonNull String tag, int level) {
        return Log.isLoggable((String)tag, (int)level);
    }

    public static String getStackTraceString(@Nullable Throwable tr) {
        return Log.getStackTraceString((Throwable)tr);
    }

    static {
        Logger.reset();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogType {
    }
}

