/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.universi;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import universum.studios.android.dialog.manage.DialogController;
import universum.studios.android.universi.UniversiContextDelegate;

public class UniversiFragmentDelegate
extends UniversiContextDelegate {
    private final Fragment fragment;
    private final FragmentManager.FragmentLifecycleCallbacks lifecycleCallbacks = new FragmentManager.FragmentLifecycleCallbacks(){

        public void onFragmentResumed(@NonNull FragmentManager manager, @NonNull Fragment fragment) {
            super.onFragmentViewDestroyed(manager, fragment);
            if (UniversiFragmentDelegate.this.fragment == fragment) {
                UniversiFragmentDelegate.this.setPaused(false);
            }
        }

        public void onFragmentPaused(@NonNull FragmentManager manager, @NonNull Fragment fragment) {
            super.onFragmentViewDestroyed(manager, fragment);
            if (UniversiFragmentDelegate.this.fragment == fragment) {
                UniversiFragmentDelegate.this.setPaused(true);
            }
        }

        public void onFragmentViewDestroyed(@NonNull FragmentManager manager, @NonNull Fragment fragment) {
            super.onFragmentViewDestroyed(manager, fragment);
            if (UniversiFragmentDelegate.this.fragment == fragment) {
                UniversiFragmentDelegate.this.setViewCreated(false);
            }
        }
    };

    @VisibleForTesting
    UniversiFragmentDelegate(@NonNull Fragment fragment) {
        this.fragment = fragment;
        this.fragment.getParentFragmentManager().registerFragmentLifecycleCallbacks(this.lifecycleCallbacks, false);
    }

    @NonNull
    public static UniversiFragmentDelegate create(@NonNull Fragment fragment) {
        return new UniversiFragmentDelegate(fragment);
    }

    @Override
    @NonNull
    protected Context requireContext() {
        return this.fragment.requireContext();
    }

    @Override
    @NonNull
    protected final DialogController createDialogController() {
        return DialogController.create((Fragment)this.fragment);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.fragment.getParentFragmentManager().unregisterFragmentLifecycleCallbacks(this.lifecycleCallbacks);
    }
}

