/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.universi;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.view.Menu;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.XmlRes;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import universum.studios.android.dialog.DialogOptions;
import universum.studios.android.dialog.manage.DialogController;
import universum.studios.android.dialog.manage.DialogFactory;
import universum.studios.android.fragment.ActionBarDelegate;
import universum.studios.android.fragment.BackPressWatcher;
import universum.studios.android.fragment.annotation.FragmentAnnotations;
import universum.studios.android.fragment.annotation.handler.ActionBarAnnotationHandlers;
import universum.studios.android.fragment.annotation.handler.ActionBarFragmentAnnotationHandler;
import universum.studios.android.fragment.manage.FragmentController;
import universum.studios.android.fragment.manage.FragmentFactory;
import universum.studios.android.transition.BaseNavigationalTransition;
import universum.studios.android.universi.UniversiActivityContext;
import universum.studios.android.universi.UniversiActivityDelegate;

public abstract class UniversiCompatActivity
extends AppCompatActivity
implements UniversiActivityContext {
    @VisibleForTesting
    final Runnable requestBindDataInner = new Runnable(){

        @Override
        public void run() {
            UniversiCompatActivity.this.requestBindDataInner();
        }
    };
    private final ActionBarFragmentAnnotationHandler annotationHandler = ActionBarAnnotationHandlers.obtainActionBarFragmentHandler(this.getClass());
    private UniversiActivityDelegate delegate;

    @NonNull
    protected ActionBarFragmentAnnotationHandler getAnnotationHandler() {
        FragmentAnnotations.checkIfEnabledOrThrow();
        return this.annotationHandler;
    }

    @VisibleForTesting
    void setContextDelegate(UniversiActivityDelegate delegate) {
        this.delegate = delegate;
    }

    private void ensureContextDelegate() {
        if (this.delegate == null) {
            this.delegate = UniversiActivityDelegate.create((FragmentActivity)this);
        }
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        int viewResource;
        super.onCreate(savedInstanceState);
        this.ensureContextDelegate();
        if (this.annotationHandler != null && (viewResource = this.annotationHandler.getContentViewResource(-1)) != -1) {
            this.setContentView(viewResource);
        }
    }

    public void onContentChanged() {
        super.onContentChanged();
        this.ensureContextDelegate();
        this.delegate.setViewCreated(true);
        this.configureActionBar(this.getSupportActionBar());
        this.onBindView();
        if (this.delegate.isRequestRegistered(1)) {
            this.delegate.unregisterRequest(1);
            this.onBindData();
        }
    }

    public void setSupportActionBar(@Nullable Toolbar toolbar) {
        super.setSupportActionBar(toolbar);
        this.configureActionBar(this.getSupportActionBar());
    }

    private void configureActionBar(ActionBar actionBar) {
        if (actionBar == null || this.annotationHandler == null) {
            return;
        }
        this.annotationHandler.configureActionBar(ActionBarDelegate.create((Context)this, (ActionBar)actionBar));
    }

    protected void onBindView() {
    }

    public boolean onCreateOptionsMenu(@NonNull Menu menu) {
        if (this.annotationHandler == null || !this.annotationHandler.hasOptionsMenu()) {
            return false;
        }
        int menuResource = this.annotationHandler.getOptionsMenuResource(-1);
        if (menuResource == -1) {
            return super.onCreateOptionsMenu(menu);
        }
        if (this.annotationHandler.shouldClearOptionsMenu()) {
            menu.clear();
        }
        switch (this.annotationHandler.getOptionsMenuFlags(0)) {
            case 1: {
                this.getMenuInflater().inflate(menuResource, menu);
                break;
            }
            case 2: {
                this.getMenuInflater().inflate(menuResource, menu);
                super.onCreateOptionsMenu(menu);
                break;
            }
            default: {
                super.onCreateOptionsMenu(menu);
                this.getMenuInflater().inflate(menuResource, menu);
            }
        }
        return true;
    }

    @Override
    public void setNavigationalTransition(@Nullable BaseNavigationalTransition transition) {
        this.ensureContextDelegate();
        this.delegate.setNavigationalTransition(transition);
    }

    @Override
    @Nullable
    public BaseNavigationalTransition getNavigationalTransition() {
        this.ensureContextDelegate();
        return this.delegate.getNavigationalTransition();
    }

    @Override
    @NonNull
    public FragmentController getFragmentController() {
        this.ensureContextDelegate();
        return this.delegate.getFragmentController();
    }

    @Override
    public void setFragmentController(@Nullable FragmentController controller) {
        this.ensureContextDelegate();
        this.delegate.setFragmentController(controller);
    }

    @Override
    public void setFragmentFactory(@Nullable FragmentFactory factory) {
        this.ensureContextDelegate();
        this.delegate.setFragmentFactory(factory);
    }

    @Override
    @Nullable
    public FragmentFactory getFragmentFactory() {
        this.ensureContextDelegate();
        return this.delegate.getFragmentFactory();
    }

    @Override
    public void setDialogController(@Nullable DialogController controller) {
        this.ensureContextDelegate();
        this.delegate.setDialogController(controller);
    }

    @Override
    @NonNull
    public DialogController getDialogController() {
        this.ensureContextDelegate();
        return this.delegate.getDialogController();
    }

    @Override
    public void setDialogXmlFactory(@XmlRes int xmlDialogsSet) {
        this.ensureContextDelegate();
        this.delegate.setDialogXmlFactory(xmlDialogsSet);
    }

    @Override
    public void setDialogFactory(@Nullable DialogFactory factory) {
        this.ensureContextDelegate();
        this.delegate.setDialogFactory(factory);
    }

    @Override
    @Nullable
    public DialogFactory getDialogFactory() {
        this.ensureContextDelegate();
        return this.delegate.getDialogFactory();
    }

    protected void requestBindData() {
        if (Looper.getMainLooper().equals(Looper.myLooper())) {
            this.requestBindDataInner();
        } else {
            this.runOnUiThread(this.requestBindDataInner);
        }
    }

    final void requestBindDataInner() {
        this.ensureContextDelegate();
        if (this.delegate.isViewCreated()) {
            this.onBindData();
            return;
        }
        this.delegate.registerRequest(1);
    }

    @UiThread
    protected void onBindData() {
    }

    public int checkSelfPermission(@NonNull String permission) {
        return Build.VERSION.SDK_INT >= 23 ? super.checkSelfPermission(permission) : 0;
    }

    public boolean shouldShowRequestPermissionRationale(@NonNull String permission) {
        return Build.VERSION.SDK_INT >= 23 && super.shouldShowRequestPermissionRationale(permission);
    }

    public void supportRequestPermissions(@NonNull String[] permissions, int requestCode) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissions(permissions, requestCode);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public boolean showDialogWithId(int dialogId) {
        return this.showDialogWithId(dialogId, null);
    }

    @Override
    public boolean showDialogWithId(int dialogId, @Nullable DialogOptions options) {
        this.ensureContextDelegate();
        return this.delegate.showDialogWithId(dialogId, options);
    }

    @Override
    public boolean dismissDialogWithId(int dialogId) {
        this.ensureContextDelegate();
        return this.delegate.dismissDialogWithId(dialogId);
    }

    @Override
    public boolean showXmlDialog(@XmlRes int resId) {
        return this.showXmlDialog(resId, null);
    }

    @Override
    public boolean showXmlDialog(@XmlRes int resId, @Nullable DialogOptions options) {
        this.ensureContextDelegate();
        return this.delegate.showXmlDialog(resId, options);
    }

    @Override
    public boolean dismissXmlDialog(@XmlRes int resId) {
        this.ensureContextDelegate();
        return this.delegate.dismissXmlDialog(resId);
    }

    public void onBackPressed() {
        if (!this.onBackPress()) {
            this.finishWithNavigationalTransition();
        }
    }

    protected boolean onBackPress() {
        this.ensureContextDelegate();
        return !this.delegate.isPaused() && (this.dispatchBackPressToFragments() || this.popFragmentsBackStack());
    }

    protected boolean dispatchBackPressToFragments() {
        return this.dispatchBackPressToCurrentFragment();
    }

    protected boolean dispatchBackPressToCurrentFragment() {
        Fragment fragment = this.findCurrentFragment();
        return fragment instanceof BackPressWatcher && ((BackPressWatcher)fragment).dispatchBackPress();
    }

    @Nullable
    protected Fragment findCurrentFragment() {
        this.ensureContextDelegate();
        return this.delegate.findCurrentFragment();
    }

    protected boolean popFragmentsBackStack() {
        this.ensureContextDelegate();
        return this.delegate.popFragmentsBackStack();
    }

    @Override
    public boolean finishWithNavigationalTransition() {
        this.ensureContextDelegate();
        if (this.delegate.finishWithNavigationalTransition()) {
            return true;
        }
        this.supportFinishAfterTransition();
        return false;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.delegate != null) {
            this.delegate.destroy();
            this.delegate = null;
        }
    }
}

