/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.universi;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import universum.studios.android.dialog.manage.DialogController;
import universum.studios.android.fragment.manage.FragmentController;
import universum.studios.android.fragment.manage.FragmentFactory;
import universum.studios.android.transition.BaseNavigationalTransition;
import universum.studios.android.universi.UniversiContextDelegate;

public class UniversiActivityDelegate
extends UniversiContextDelegate {
    private final FragmentActivity activity;
    private final Application.ActivityLifecycleCallbacks lifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        }

        public void onActivityStarted(@NonNull Activity activity) {
        }

        public void onActivityResumed(@NonNull Activity activity) {
            if (UniversiActivityDelegate.this.activity == activity) {
                UniversiActivityDelegate.this.setPaused(false);
            }
        }

        public void onActivityPaused(@NonNull Activity activity) {
            if (UniversiActivityDelegate.this.activity == activity) {
                UniversiActivityDelegate.this.setPaused(true);
            }
        }

        public void onActivityStopped(@NonNull Activity activity) {
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
            if (UniversiActivityDelegate.this.activity == activity) {
                UniversiActivityDelegate.this.setViewCreated(false);
            }
        }
    };
    private FragmentController fragmentController;
    private FragmentFactory fragmentFactory;
    private BaseNavigationalTransition navigationalTransition;

    @VisibleForTesting
    UniversiActivityDelegate(@NonNull FragmentActivity activity) {
        this.activity = activity;
        this.activity.getApplication().registerActivityLifecycleCallbacks(this.lifecycleCallbacks);
    }

    @NonNull
    public static UniversiActivityDelegate create(@NonNull FragmentActivity activity) {
        return new UniversiActivityDelegate(activity);
    }

    @Override
    @NonNull
    protected Context requireContext() {
        return this.activity;
    }

    @Override
    @NonNull
    protected final DialogController createDialogController() {
        return DialogController.create((FragmentActivity)this.activity);
    }

    public void setNavigationalTransition(@Nullable BaseNavigationalTransition transition) {
        this.navigationalTransition = transition;
        if (transition != null) {
            transition.configureIncomingTransitions((Activity)this.activity);
        }
    }

    @Nullable
    public BaseNavigationalTransition getNavigationalTransition() {
        return this.navigationalTransition;
    }

    public boolean finishWithNavigationalTransition() {
        if (this.navigationalTransition == null) {
            return false;
        }
        this.navigationalTransition.finish((Activity)this.activity);
        return true;
    }

    public void setFragmentController(@Nullable FragmentController controller) {
        this.fragmentController = controller;
        if (this.fragmentFactory != null) {
            this.ensureFragmentController();
            this.fragmentController.setFactory(this.fragmentFactory);
        }
    }

    @NonNull
    public FragmentController getFragmentController() {
        this.ensureFragmentController();
        return this.fragmentController;
    }

    public void setFragmentFactory(@Nullable FragmentFactory factory) {
        this.fragmentFactory = factory;
        this.ensureFragmentController();
        this.fragmentController.setFactory(factory);
    }

    @Nullable
    public FragmentFactory getFragmentFactory() {
        return this.fragmentFactory;
    }

    private void ensureFragmentController() {
        if (this.fragmentController == null) {
            this.fragmentController = FragmentController.create((FragmentActivity)this.activity);
        }
    }

    @Nullable
    public Fragment findCurrentFragment() {
        return this.fragmentController == null ? null : this.fragmentController.findCurrentFragment();
    }

    public boolean popFragmentsBackStack() {
        FragmentManager fragmentManager = this.activity.getSupportFragmentManager();
        if (fragmentManager.getBackStackEntryCount() > 0) {
            fragmentManager.popBackStack();
            return true;
        }
        return false;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.activity.getApplication().unregisterActivityLifecycleCallbacks(this.lifecycleCallbacks);
        if (this.fragmentController != null) {
            this.fragmentController.destroy();
            this.fragmentController = null;
        }
    }
}

