/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.universi;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.view.View;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.XmlRes;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import universum.studios.android.dialog.DialogOptions;
import universum.studios.android.dialog.manage.DialogController;
import universum.studios.android.dialog.manage.DialogFactory;
import universum.studios.android.fragment.ActionBarFragment;
import universum.studios.android.universi.UniversiContextDelegate;
import universum.studios.android.universi.UniversiFragmentDelegate;

public abstract class UniversiFragment
extends ActionBarFragment {
    @VisibleForTesting
    final Runnable REQUEST_BIND_DATA_INNER = new Runnable(){

        @Override
        public void run() {
            UniversiFragment.this.requestBindDataInner();
        }
    };
    private UniversiContextDelegate delegate;

    @VisibleForTesting
    void setContextDelegate(UniversiContextDelegate delegate) {
        this.delegate = delegate;
    }

    private void ensureContextDelegate() {
        if (this.delegate == null) {
            this.delegate = UniversiFragmentDelegate.create((Fragment)this);
        }
    }

    protected void setDialogController(@Nullable DialogController controller) {
        this.ensureContextDelegate();
        this.delegate.setDialogController(controller);
    }

    @NonNull
    protected DialogController getDialogController() {
        this.ensureContextDelegate();
        return this.delegate.getDialogController();
    }

    protected void setDialogXmlFactory(@XmlRes int xmlDialogsSet) {
        this.ensureContextDelegate();
        this.delegate.setDialogXmlFactory(xmlDialogsSet);
    }

    protected void setDialogFactory(@Nullable DialogFactory factory) {
        this.ensureContextDelegate();
        this.delegate.setDialogFactory(factory);
    }

    @Nullable
    protected DialogFactory getDialogFactory() {
        this.ensureContextDelegate();
        return this.delegate.getDialogFactory();
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.ensureContextDelegate();
        this.delegate.setViewCreated(true);
        this.onBindViews(view, savedInstanceState);
        if (this.delegate.isRequestRegistered(1)) {
            this.delegate.unregisterRequest(1);
            this.onBindData();
        }
    }

    protected void onBindViews(@NonNull View rootView, @Nullable Bundle savedInstanceState) {
    }

    public void onResume() {
        super.onResume();
        this.ensureContextDelegate();
        this.delegate.setStateSaved(false);
        this.delegate.setPaused(false);
    }

    protected void requestBindData() {
        if (Looper.getMainLooper().equals(Looper.myLooper())) {
            this.requestBindDataInner();
        } else {
            this.runOnUiThread(this.REQUEST_BIND_DATA_INNER);
        }
    }

    final void requestBindDataInner() {
        this.ensureContextDelegate();
        if (this.delegate.isViewCreated()) {
            this.onBindData();
            return;
        }
        this.delegate.registerRequest(1);
    }

    @UiThread
    protected void onBindData() {
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @CheckResult
    protected boolean isActiveNetworkConnected() {
        this.ensureContextDelegate();
        return this.delegate.isActiveNetworkConnected();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @CheckResult
    protected boolean isNetworkConnected(int networkType) {
        this.ensureContextDelegate();
        return this.delegate.isNetworkConnected(networkType);
    }

    @CheckResult
    protected int checkSelfPermission(@NonNull String permission) {
        return ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)permission);
    }

    @CheckResult
    public boolean shouldShowRequestPermissionRationale(@NonNull String permission) {
        return Build.VERSION.SDK_INT >= 23 && super.shouldShowRequestPermissionRationale(permission);
    }

    protected void supportRequestPermissions(@NonNull String[] permissions, int requestCode) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissions(permissions, requestCode);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    protected boolean showDialogWithId(int dialogId) {
        return this.showDialogWithId(dialogId, null);
    }

    protected boolean showDialogWithId(int dialogId, @Nullable DialogOptions options) {
        this.ensureContextDelegate();
        return this.delegate.showDialogWithId(dialogId, options);
    }

    protected boolean dismissDialogWithId(int dialogId) {
        this.ensureContextDelegate();
        return this.delegate.dismissDialogWithId(dialogId);
    }

    protected boolean showXmlDialog(@XmlRes int resId) {
        return this.showXmlDialog(resId, null);
    }

    protected boolean showXmlDialog(@XmlRes int resId, @Nullable DialogOptions options) {
        this.ensureContextDelegate();
        return this.delegate.showXmlDialog(resId, options);
    }

    protected boolean dismissXmlDialog(@XmlRes int resId) {
        this.ensureContextDelegate();
        return this.delegate.dismissXmlDialog(resId);
    }

    public void onSaveInstanceState(@NonNull Bundle state) {
        super.onSaveInstanceState(state);
        this.ensureContextDelegate();
        this.delegate.setStateSaved(true);
    }

    public void onPause() {
        super.onPause();
        this.ensureContextDelegate();
        this.delegate.setPaused(true);
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.delegate != null) {
            this.delegate.setViewCreated(false);
        }
    }
}

