/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.universi;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import universum.studios.android.dialog.manage.DialogController;
import universum.studios.android.fragment.manage.FragmentController;
import universum.studios.android.fragment.manage.FragmentFactory;
import universum.studios.android.transition.BaseNavigationalTransition;
import universum.studios.android.universi.UniversiContextDelegate;

public class UniversiActivityDelegate
extends UniversiContextDelegate {
    private FragmentController fragmentController;
    private FragmentFactory fragmentFactory;
    private BaseNavigationalTransition navigationalTransition;

    @VisibleForTesting
    UniversiActivityDelegate(@NonNull Activity context) {
        super((Context)context);
    }

    @NonNull
    public static UniversiActivityDelegate create(@NonNull FragmentActivity activity) {
        return new UniversiActivityDelegate((Activity)activity);
    }

    @Override
    @NonNull
    final DialogController instantiateDialogController() {
        return DialogController.create((FragmentActivity)((FragmentActivity)this.context));
    }

    public void setNavigationalTransition(@Nullable BaseNavigationalTransition transition) {
        this.navigationalTransition = transition;
        if (transition != null) {
            transition.configureIncomingTransitions((Activity)this.context);
        }
    }

    @Nullable
    public BaseNavigationalTransition getNavigationalTransition() {
        return this.navigationalTransition;
    }

    public boolean finishWithNavigationalTransition() {
        if (this.navigationalTransition == null) {
            return false;
        }
        this.navigationalTransition.finish((Activity)this.context);
        return true;
    }

    public void setFragmentController(@Nullable FragmentController controller) {
        this.fragmentController = controller;
        if (this.fragmentFactory != null) {
            this.ensureFragmentController();
            this.fragmentController.setFactory(this.fragmentFactory);
        }
    }

    @NonNull
    public FragmentController getFragmentController() {
        this.ensureFragmentController();
        return this.fragmentController;
    }

    public void setFragmentFactory(@Nullable FragmentFactory factory) {
        this.fragmentFactory = factory;
        this.ensureFragmentController();
        this.fragmentController.setFactory(factory);
    }

    @Nullable
    public FragmentFactory getFragmentFactory() {
        return this.fragmentFactory;
    }

    private void ensureFragmentController() {
        if (this.fragmentController == null) {
            this.fragmentController = FragmentController.create((FragmentActivity)((FragmentActivity)this.context));
        }
    }

    @Nullable
    public Fragment findCurrentFragment() {
        return this.fragmentController == null ? null : this.fragmentController.findCurrentFragment();
    }

    public boolean popFragmentsBackStack() {
        FragmentManager fragmentManager = ((FragmentActivity)this.context).getSupportFragmentManager();
        if (fragmentManager.getBackStackEntryCount() > 0) {
            fragmentManager.popBackStack();
            return true;
        }
        return false;
    }
}

