/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.universi;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.XmlRes;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import universum.studios.android.dialog.DialogOptions;
import universum.studios.android.dialog.manage.DialogController;
import universum.studios.android.dialog.manage.DialogFactory;
import universum.studios.android.dialog.manage.DialogXmlFactory;

public abstract class UniversiContextDelegate {
    static final int REQUEST_BIND_DATA = 1;
    private static final int PFLAG_VIEW_CREATED = 1;
    private static final int PFLAG_STATE_SAVED = 2;
    private static final int PFLAG_PAUSED = 4;
    final Context context;
    private int privateFlags;
    private int requestFlags;
    private DialogController dialogController;
    private DialogFactory dialogFactory;
    private DialogXmlFactory dialogXmlFactory;
    private ConnectivityManager connectivityManager;

    UniversiContextDelegate(@NonNull Context context) {
        this.context = context;
    }

    public void setDialogController(@Nullable DialogController controller) {
        this.dialogController = controller;
        if (this.dialogFactory != null) {
            this.ensureDialogController();
            this.dialogController.setFactory(this.dialogFactory);
        }
    }

    @NonNull
    public DialogController getDialogController() {
        this.ensureDialogController();
        return this.dialogController;
    }

    private void ensureDialogController() {
        if (this.dialogController == null) {
            this.dialogController = this.instantiateDialogController();
        }
    }

    @NonNull
    abstract DialogController instantiateDialogController();

    public void setDialogXmlFactory(@XmlRes int xmlDialogsSet) {
        this.setDialogFactory((DialogFactory)(xmlDialogsSet == 0 ? null : new DialogXmlFactory(this.context, xmlDialogsSet)));
    }

    public void setDialogFactory(@Nullable DialogFactory factory) {
        this.dialogFactory = factory;
        this.ensureDialogController();
        this.dialogController.setFactory(factory);
    }

    @Nullable
    public DialogFactory getDialogFactory() {
        return this.dialogFactory;
    }

    public boolean showDialogWithId(int dialogId, @Nullable DialogOptions options) {
        if (this.hasPrivateFlag(6) || this.dialogFactory == null) {
            return false;
        }
        this.ensureDialogController();
        return this.dialogController.newRequest(dialogId).options(options).execute() != null;
    }

    public boolean dismissDialogWithId(int dialogId) {
        if (this.hasPrivateFlag(4) || this.dialogFactory == null) {
            return false;
        }
        this.ensureDialogController();
        return this.dialogController.newRequest(dialogId).intent(1).allowStateLoss(true).execute() != null;
    }

    public boolean showXmlDialog(@XmlRes int resId, @Nullable DialogOptions options) {
        if (this.hasPrivateFlag(6)) {
            return false;
        }
        DialogXmlFactory dialogFactory = this.accessDialogXmlFactory();
        DialogFragment dialog = dialogFactory.createDialog(resId, options);
        if (dialog == null) {
            return false;
        }
        this.ensureDialogController();
        return this.dialogController.newRequest(dialog).tag(dialogFactory.createDialogTag(resId)).execute() != null;
    }

    public boolean dismissXmlDialog(@XmlRes int resId) {
        if (this.hasPrivateFlag(4)) {
            return false;
        }
        this.ensureDialogController();
        Fragment fragment = this.dialogController.getFragmentManager().findFragmentByTag(this.accessDialogXmlFactory().createDialogTag(resId));
        return fragment instanceof DialogFragment && this.dialogController.newRequest((DialogFragment)fragment).intent(1).allowStateLoss(true).execute() != null;
    }

    private DialogXmlFactory accessDialogXmlFactory() {
        if (this.dialogFactory instanceof DialogXmlFactory) {
            return (DialogXmlFactory)this.dialogFactory;
        }
        if (this.dialogXmlFactory == null) {
            this.dialogXmlFactory = new DialogXmlFactory(this.context);
        }
        return this.dialogXmlFactory;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isActiveNetworkConnected() {
        this.ensureConnectivityManager();
        NetworkInfo info = this.connectivityManager.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public boolean isNetworkConnected(int networkType) {
        this.ensureConnectivityManager();
        NetworkInfo info = this.connectivityManager.getNetworkInfo(networkType);
        return info != null && info.isConnected();
    }

    private void ensureConnectivityManager() {
        if (this.connectivityManager == null) {
            Context applicationContext = this.context.getApplicationContext();
            this.connectivityManager = (ConnectivityManager)applicationContext.getSystemService("connectivity");
        }
    }

    public void setViewCreated(boolean created) {
        this.updatePrivateFlags(1, created);
    }

    public boolean isViewCreated() {
        return this.hasPrivateFlag(1);
    }

    public void setStateSaved(boolean saved) {
        this.updatePrivateFlags(2, saved);
    }

    public boolean isStateSaved() {
        return this.hasPrivateFlag(2);
    }

    public void setPaused(boolean paused) {
        this.updatePrivateFlags(4, paused);
    }

    public boolean isPaused() {
        return this.hasPrivateFlag(4);
    }

    public void registerRequest(int requestFlag) {
        this.requestFlags |= requestFlag;
    }

    public void unregisterRequest(int requestFlag) {
        this.requestFlags &= ~requestFlag;
    }

    public boolean isRequestRegistered(int requestFlag) {
        return (this.requestFlags & requestFlag) != 0;
    }

    private void updatePrivateFlags(int flag, boolean add) {
        this.privateFlags = add ? (this.privateFlags |= flag) : (this.privateFlags &= ~flag);
    }

    private boolean hasPrivateFlag(int flag) {
        return (this.privateFlags & flag) != 0;
    }
}

