/*
 * *************************************************************************************************
 *                                 Copyright 2017 Universum Studios
 * *************************************************************************************************
 *                  Licensed under the Apache License, Version 2.0 (the "License")
 * -------------------------------------------------------------------------------------------------
 * You may not use this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * *************************************************************************************************
 */
/**
 * Provides 'universal' implementations of {@link android.app.Activity Activity} and
 * {@link android.app.Fragment Fragment} classes that may be used as base parents for all activities
 * and fragments used across Android application.
 * {@link universum.studios.android.universi.UniversiActivity UniversiActivity} along with
 * {@link universum.studios.android.universi.UniversiFragment UniversiFragment} provide helper
 * methods and callbacks to simplify data loading via content loaders, data binding using Android's
 * <a href="https://developer.android.com/topic/libraries/data-binding/index.html">Data Binding Library</a>
 * and also simplified showing of Fragments and DialogFragments and other useful features.
 *
 * @author Martin Albedinsky
 * @since 1.0
 */
package universum.studios.android.universi;