/*
 * =================================================================================================
 *                             Copyright (C) 2017 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
/**
 * Provides 'universal' implementations of {@link android.app.Activity Activity} and
 * {@link android.app.Fragment Fragment} classes that may be used as base parents for all
 * activities and fragments used across Android application.
 * {@link universum.studios.android.universi.UniversiActivity UniversiActivity} along with
 * {@link universum.studios.android.universi.UniversiFragment UniversiFragment} provide helper
 * methods and callbacks to simplify data loading via content loaders, data binding using
 * Android's <a href="https://developer.android.com/topic/libraries/data-binding/index.html">Data Binding Library</a>
 * and also simplified showing of Fragments and DialogFragments and other useful features.
 *
 * @author Martin Albedinsky
 */
package universum.studios.android.universi;